/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.regression.RegressionInterpolator;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public final class RegressionInterpolatorAction
extends AbstractAction {
    private DataEditor dataEditor;

    public RegressionInterpolatorAction(DataEditor editor) {
        super("Replace Missing Values with Regression Predictions");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel dataModel = this.getDataEditor().getSelectedDataModel();
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            RegressionInterpolator interpolator = new RegressionInterpolator();
            DataSet newDataSet = null;
            try {
                newDataSet = interpolator.filter(dataSet);
            }
            catch (IllegalArgumentException e1) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Error: " + e1.getMessage());
                throw e1;
            }
            DataModelList list = new DataModelList();
            list.add(newDataSet);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else if (dataModel instanceof CovarianceMatrix) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Must be a tabular data set.");
        }
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }
}

