/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.RegressionParams;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

final class RegressionParamsPanel
extends JPanel
implements ActionListener {
    private RegressionParams params;
    private String targetName;
    private List<String> varNames;
    private String[] regressorNames;
    private JTextField responseVar;
    private JList availableVarsList;
    private JList predictorVarListbox;
    private ArrowButton responseButton;
    private static final String INCLUDE_RESPONSE = "includeResponse";
    private static final String INCLUDE_PREDICTOR = "includePredictor";
    private static final String EXCLUDE_PREDICTOR = "excludePredictor";

    /*
     * WARNING - void declaration
     */
    public RegressionParamsPanel(RegressionParams params, Object[] parentModels) {
        void var18_22;
        String[] regNames;
        String[] paramNames;
        if (params == null) {
            throw new NullPointerException("RegressionParams must not be null.");
        }
        this.params = params;
        if (params.getVarNames() != null) {
            this.varNames = params.getVarNames();
        }
        if (this.varNames == null) {
            this.varNames = this.getVarsFromData(parentModels);
            if (this.varNames == null) {
                this.varNames = this.getVarsFromGraph(parentModels);
            }
            params.setVarNames(this.varNames);
            if (this.varNames == null) {
                throw new IllegalStateException("Variables are not accessible.");
            }
            this.params().setVarNames(this.varNames);
        }
        JLabel instructions = new JLabel("Select response and predictor variables:");
        JLabel varsLabel = new JLabel("Variables");
        JLabel responseLabel = new JLabel("Response");
        JLabel predictorLabel = new JLabel("Predictor(s)");
        JScrollPane varListbox = (JScrollPane)this.createVarListbox();
        JScrollPane predictorVarListbox = (JScrollPane)this.createPredictorVarListbox();
        this.responseButton = new ArrowButton(this, INCLUDE_RESPONSE);
        ArrowButton predictorInButton = new ArrowButton(this, INCLUDE_PREDICTOR);
        ArrowButton predictorOutButton = new ArrowButton(this, EXCLUDE_PREDICTOR, false);
        this.responseVar = new StringTextField("", 10);
        this.responseVar.setEditable(false);
        this.responseVar.setBackground(Color.white);
        this.responseVar.setPreferredSize(new Dimension(150, 30));
        this.responseVar.setFont(new Font("SanSerif", 1, 12));
        this.responseVar.setText(params.getTargetName());
        if (!this.responseVar.getText().equals("") && this.responseButton.getText().equals(">")) {
            this.responseButton.toggleInclude();
        }
        DefaultListModel predsModel = (DefaultListModel)this.predictorVarListbox.getModel();
        for (String paramName : paramNames = params.getRegressorNames()) {
            predsModel.addElement(paramName);
        }
        ArrayList<String> varListNames = new ArrayList<String>(this.varNames);
        String targetName = params.getTargetName();
        if (varListNames.contains(targetName)) {
            varListNames.remove(targetName);
        }
        String[] arr$ = regNames = params.getRegressorNames();
        int len$ = arr$.length;
        boolean bl = false;
        while (var18_22 < len$) {
            String regName = arr$[var18_22];
            if (varListNames.contains(regName)) {
                varListNames.remove(regName);
            }
            ++var18_22;
        }
        DefaultListModel varsModel = (DefaultListModel)this.availableVarsList.getModel();
        varsModel.clear();
        for (Object e : varListNames) {
            varsModel.addElement(e);
        }
        this.setLayout(new BoxLayout(this, 1));
        Box b = Box.createVerticalBox();
        Box box = Box.createHorizontalBox();
        box.add(instructions);
        Box b1 = Box.createHorizontalBox();
        Box b2 = Box.createVerticalBox();
        Box b3 = Box.createVerticalBox();
        Box b4 = Box.createVerticalBox();
        Box b5 = Box.createVerticalBox();
        DoubleTextField alphaField = new DoubleTextField(params.getAlpha(), 4, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    RegressionParamsPanel.this.params().setAlpha(value);
                    Preferences.userRoot().putDouble("alpha", RegressionParamsPanel.this.params().getAlpha());
                    return value;
                }
                catch (Exception e) {
                    return oldValue;
                }
            }
        });
        JLabel alphaLabel = new JLabel("Alpha:");
        b2.add(varsLabel);
        b2.add(varListbox);
        b2.add(alphaLabel);
        b2.add(alphaField);
        b3.add(this.responseButton);
        Component strut3 = Box.createVerticalStrut(90);
        b3.add(strut3);
        b3.add(predictorInButton);
        b3.add(predictorOutButton);
        responseLabel.setPreferredSize(new Dimension(80, 30));
        b4.add(responseLabel);
        Component strut42 = Box.createVerticalStrut(120);
        b4.add(strut42);
        b4.add(predictorLabel);
        b5.add(this.responseVar);
        Component strut5 = Box.createVerticalStrut(10);
        b5.add(strut5);
        b5.add(predictorVarListbox);
        b1.add(b2);
        b1.add(b3);
        b1.add(b4);
        b1.add(b5);
        b.add(box);
        b.add(b1);
        this.add(b);
    }

    private JComponent createVarListbox() {
        this.availableVarsList = new JList(new DefaultListModel());
        DefaultListModel varsModel = (DefaultListModel)this.availableVarsList.getModel();
        for (String varName : this.varNames) {
            varsModel.addElement(varName);
        }
        this.availableVarsList.setVisibleRowCount(5);
        this.availableVarsList.setFixedCellWidth(100);
        this.availableVarsList.setSelectionMode(0);
        this.availableVarsList.setSelectedIndex(0);
        return new JScrollPane(this.availableVarsList);
    }

    private JComponent createPredictorVarListbox() {
        this.predictorVarListbox = new JList(new DefaultListModel());
        this.predictorVarListbox.setVisibleRowCount(4);
        this.predictorVarListbox.setFixedCellWidth(100);
        this.predictorVarListbox.setSelectionMode(0);
        this.predictorVarListbox.setSelectedIndex(0);
        return new JScrollPane(this.predictorVarListbox);
    }

    private List<String> getVarsFromData(Object[] parentModels) {
        VariableSource dataModel = null;
        for (Object parentModel : parentModels) {
            if (!(parentModel instanceof DataWrapper)) continue;
            DataWrapper dataWrapper = (DataWrapper)parentModel;
            dataModel = dataWrapper.getSelectedDataModel();
        }
        if (dataModel == null) {
            return null;
        }
        return new ArrayList<String>(dataModel.getVariableNames());
    }

    private List<String> getVarsFromGraph(Object[] parentModels) {
        Object graphWrapper = null;
        for (Object parentModel : parentModels) {
            if (parentModel instanceof GraphWrapper) {
                graphWrapper = parentModel;
                continue;
            }
            if (!(parentModel instanceof DagWrapper)) continue;
            graphWrapper = parentModel;
        }
        if (graphWrapper == null) {
            return null;
        }
        Graph graph = null;
        if (graphWrapper instanceof GraphWrapper) {
            graph = ((GraphWrapper)graphWrapper).getGraph();
        } else if (graphWrapper instanceof DagWrapper) {
            graph = ((DagWrapper)graphWrapper).getDag();
        }
        List<Node> nodes = graph.getNodes();
        LinkedList<String> nodeNames = new LinkedList<String>();
        for (Node node : nodes) {
            nodeNames.add(node.getName());
        }
        return nodeNames;
    }

    private void setRegressorValues() {
    }

    private void setRegressorNames(String[] names) {
        this.regressorNames = names;
    }

    private RegressionParams params() {
        return this.params;
    }

    private String targetName() {
        return this.targetName;
    }

    private void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultListModel varsModel = (DefaultListModel)this.availableVarsList.getModel();
        DefaultListModel predsModel = (DefaultListModel)this.predictorVarListbox.getModel();
        String varName = varsModel.size() != 0 ? (String)this.availableVarsList.getSelectedValue() : "";
        String predictorName = predsModel.size() != 0 ? (String)this.predictorVarListbox.getSelectedValue() : "";
        if (e.getActionCommand().equals(INCLUDE_RESPONSE)) {
            if (this.availableVarsList.isSelectionEmpty() && this.responseButton.getIsIncluded()) {
                return;
            }
            if (this.responseButton.getIsIncluded()) {
                this.responseVar.setText(varName);
                varsModel.removeElement(varName);
            } else {
                varsModel.addElement(this.responseVar.getText());
                this.responseVar.setText("");
            }
            this.responseButton.toggleInclude();
            String newTargetName = this.responseVar.getText();
            this.setTargetName(newTargetName);
            this.params().setTargetName(this.targetName());
        } else if (e.getActionCommand().equals(INCLUDE_PREDICTOR)) {
            if (this.availableVarsList.isSelectionEmpty()) {
                return;
            }
            varsModel.removeElement(varName);
            predsModel.addElement(varName);
        } else if (e.getActionCommand().equals(EXCLUDE_PREDICTOR)) {
            if (this.predictorVarListbox.isSelectionEmpty()) {
                return;
            }
            predsModel.removeElement(predictorName);
            varsModel.addElement(predictorName);
        } else {
            return;
        }
        int varSelectionIndex = this.availableVarsList.getSelectedIndex();
        int predictorVarSelectionIndex = this.predictorVarListbox.getSelectedIndex();
        if (varSelectionIndex > 0) {
            --varSelectionIndex;
        }
        if (varSelectionIndex != -1) {
            this.availableVarsList.setSelectedIndex(varSelectionIndex);
        }
        if (predictorVarSelectionIndex > 0) {
            --predictorVarSelectionIndex;
        }
        if (predictorVarSelectionIndex != -1) {
            this.predictorVarListbox.setSelectedIndex(predictorVarSelectionIndex);
        }
        int numPredictors = predsModel.size();
        Object[] predictors = new Object[numPredictors];
        String[] regNames = new String[numPredictors];
        for (int i = 0; i < numPredictors; ++i) {
            predictors[i] = predsModel.getElementAt(i);
            regNames[i] = (String)predsModel.getElementAt(i);
        }
        this.setRegressorValues();
        this.setRegressorNames(regNames);
        this.params().setRegressorNames(this.regressorNames);
    }

    public class ArrowButton
    extends JButton {
        private boolean isInclude;

        public ArrowButton(RegressionParamsPanel listener, String command) {
            this(listener, command, true);
        }

        public ArrowButton(RegressionParamsPanel listener, String command, boolean isInclude) {
            this.isInclude = isInclude;
            this.addActionListener(listener);
            this.setActionCommand(command);
            if (isInclude) {
                this.setText(">");
            } else {
                this.setText("<");
            }
        }

        public void toggleInclude() {
            if (this.isInclude) {
                this.setText("<");
                this.isInclude = false;
            } else {
                this.setText(">");
                this.isInclude = true;
            }
        }

        public boolean getIsIncluded() {
            return this.isInclude;
        }
    }
}

