/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesXmlRenderer;
import edu.cmu.tetradapp.editor.BayesImEditor;
import edu.cmu.tetradapp.model.EditorUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Serializer;

class SaveBayesImXmlAction
extends AbstractAction {
    private BayesImEditor bayesImEditor;

    public SaveBayesImXmlAction(BayesImEditor bayesImEditor) {
        super("Save Bayes IM as XML");
        if (bayesImEditor == null) {
            throw new NullPointerException("BayesImEditorWizard must not be null.");
        }
        this.bayesImEditor = bayesImEditor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            File outfile = EditorUtils.getSaveFile("bayesim", "xml", this.bayesImEditor, false, "Save Bayes IM as XML...");
            BayesIm bayesIm = this.bayesImEditor.getWizard().getBayesIm();
            FileOutputStream out = new FileOutputStream(outfile);
            Element element = BayesXmlRenderer.getElement(bayesIm);
            Document document = new Document(element);
            Serializer serializer = new Serializer(out);
            serializer.setLineSeparator("\n");
            serializer.setIndent(2);
            serializer.write(document);
            out.close();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }
}

