/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.MarkovBlanketSearchEditor;
import edu.cmu.tetradapp.model.EditorUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public final class SaveDataAction
extends AbstractAction {
    private DataEditor dataEditor;
    private MarkovBlanketSearchEditor searchEditor;
    private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    public SaveDataAction(DataEditor editor) {
        super("Save Data...");
        if (editor == null) {
            throw new NullPointerException("Data Editor must not be null.");
        }
        this.setDataEditor(editor);
    }

    public SaveDataAction(MarkovBlanketSearchEditor editor) {
        super("Save Data...");
        if (editor == null) {
            throw new NullPointerException("Editor must not be null");
        }
        this.searchEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.saveData();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Error in saving: " + e1.getMessage());
        }
    }

    private void saveData() throws IOException {
        PrintWriter out;
        File file = EditorUtils.getSaveFile("data", "txt", this.getDataEditor(), false, "Save Data...");
        if (file == null) {
            return;
        }
        char delimiter = '\t';
        if (file.getName().endsWith(".csv")) {
            delimiter = ',';
        }
        try {
            out = new PrintWriter(new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Output file could not be opened: " + file);
        }
        DataModel dataModel = this.dataEditor != null ? this.getDataEditor().getSelectedDataModel() : this.searchEditor.getDataModel();
        if (dataModel == null) {
            return;
        }
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            if (dataSet.isContinuous()) {
                DataWriter.writeRectangularData(dataSet, out, delimiter);
            } else if (dataSet.isDiscrete()) {
                DataWriter.writeRectangularData(dataSet, out, delimiter);
            } else {
                DataWriter.writeRectangularData(dataSet, out, delimiter);
            }
        } else if (dataModel instanceof CovarianceMatrix) {
            DataWriter.writeCovMatrix((CovarianceMatrix)dataModel, out, this.nf);
        } else {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Sorry, don't know how to save that.");
        }
        out.close();
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }

    private void setDataEditor(DataEditor dataEditor) {
        this.dataEditor = dataEditor;
    }
}

