/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.editor.CopySubgraphAction;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.Indexable;
import edu.cmu.tetradapp.model.ScoredGraphsWrapper;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScoredGraphsDisplay
extends JPanel
implements GraphEditable {
    private GraphWorkbench workbench;
    private boolean showHighestScoreOnly;
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private Map<Graph, Double> dagsToScores;
    private List<Graph> dags;
    private JLabel scoreLabel;
    private Indexable indexable;

    public ScoredGraphsDisplay(ScoredGraphsWrapper scoredGraphsWrapper) {
        this.indexable = scoredGraphsWrapper;
        this.dagsToScores = scoredGraphsWrapper.getGraphsToScores();
        this.setup();
    }

    public ScoredGraphsDisplay(Map<Graph, Double> dagsToScores) {
        this.dagsToScores = dagsToScores;
        this.setup();
    }

    private void setup() {
        Graph dag2;
        if (this.dagsToScores.isEmpty()) {
            throw new IllegalArgumentException("Empty map.");
        }
        double max = Double.NEGATIVE_INFINITY;
        for (Graph dag2 : this.dagsToScores.keySet()) {
            if (!(this.dagsToScores.get(dag2) > max)) continue;
            max = this.dagsToScores.get(dag2);
        }
        final ArrayList<Graph> dags = new ArrayList<Graph>();
        if (max != Double.NEGATIVE_INFINITY && this.showHighestScoreOnly) {
            for (Graph dag3 : this.dagsToScores.keySet()) {
                if (this.dagsToScores.get(dag3) != max) continue;
                dags.add(dag3);
            }
        } else {
            for (Graph dag3 : this.dagsToScores.keySet()) {
                dags.add(dag3);
            }
        }
        if (max != Double.NEGATIVE_INFINITY) {
            Collections.sort(dags, new Comparator<Graph>(){

                @Override
                public int compare(Graph graph, Graph graph1) {
                    return (int)Math.signum((Double)ScoredGraphsDisplay.this.dagsToScores.get(graph) - (Double)ScoredGraphsDisplay.this.dagsToScores.get(graph1));
                }
            });
        }
        this.dags = dags;
        dag2 = (Graph)dags.get(dags.size() - 1);
        this.workbench = new GraphWorkbench(dag2);
        final SpinnerNumberModel model = new SpinnerNumberModel(dags.size(), 1, dags.size(), 1);
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = model.getNumber().intValue();
                ScoredGraphsDisplay.this.workbench.setGraph((Graph)dags.get(index - 1));
                if (ScoredGraphsDisplay.this.indexable != null) {
                    ScoredGraphsDisplay.this.indexable.setIndex(index - 1);
                }
                ScoredGraphsDisplay.this.setScore(index - 1);
            }
        });
        JSpinner spinner = new JSpinner();
        spinner.setModel(model);
        JLabel totalLabel = new JLabel(" of " + dags.size());
        boolean i = false;
        this.scoreLabel = new JLabel();
        this.setScore(dags.size() - 1);
        spinner.setPreferredSize(new Dimension(50, 20));
        spinner.setMaximumSize(spinner.getPreferredSize());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("DAG "));
        b1.add(spinner);
        b1.add(totalLabel);
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("Score = "));
        b1.add(this.scoreLabel);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(Box.createHorizontalGlue());
        b1.add(new JButton(new CopySubgraphAction(this)));
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.workbench);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        graphPanel.add(jScrollPane);
        graphPanel.setBorder(new TitledBorder("Maximum Scoring DAGs in Pattern"));
        b2.add(graphPanel);
        b.add(b2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.menuBar(), "North");
        this.add((Component)b, "Center");
    }

    private void setScore(int i) {
        Double score = this.dagsToScores.get(this.dags.get(i));
        String text = Double.isNaN(score) ? "Not provided" : this.nf.format(score);
        this.scoreLabel.setText(text);
    }

    @Override
    public List getSelectedModelComponents() {
        Component[] components = this.getWorkbench().getComponents();
        ArrayList<TetradSerializable> selectedModelComponents = new ArrayList<TetradSerializable>();
        for (Component comp : components) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (int i = 0; i < sessionElements.size(); ++i) {
            Object o = sessionElements.get(i);
            if (!(o instanceof GraphNode)) continue;
            Node modelNode = (Node)o;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public Graph getGraph() {
        return this.workbench.getGraph();
    }

    @Override
    public void setGraph(Graph graph) {
        this.workbench.setGraph(graph);
    }

    private JMenuBar menuBar() {
        JMenu edit = new JMenu("Edit");
        JMenuItem copy = new JMenuItem(new CopySubgraphAction(this));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        edit.add(copy);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(edit);
        return menuBar;
    }

    public void setShowHighestScoreOnly(boolean showHighestScoreOnly) {
        this.showHighestScoreOnly = showHighestScoreOnly;
    }
}

