/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.knowledge_editor.KnowledgeEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GesParams;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public final class SearchParamGesEditor
extends JPanel
implements ParameterEditor {
    private GesParams params;
    private String name;
    private Object[] parentModels;
    private List<String> varNames;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (GesParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null) {
            throw new NullPointerException();
        }
        this.parentModels = parentModels;
    }

    @Override
    public void setup() {
        String msg0;
        boolean isDiscreteModel;
        this.varNames = this.params.getVarNames();
        this.name = "GES Algorithm";
        DoubleTextField cellPriorField = new DoubleTextField(this.params.getCellPrior(), 3, NumberFormatUtil.getInstance().getNumberFormat());
        cellPriorField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    SearchParamGesEditor.this.getParams().setCellPrior(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        DoubleTextField structurePriorField = new DoubleTextField(this.params.getStructurePrior(), 5, NumberFormatUtil.getInstance().getNumberFormat());
        structurePriorField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                try {
                    SearchParamGesEditor.this.getParams().setStructurePrior(value);
                    return value;
                }
                catch (IllegalArgumentException e) {
                    return oldValue;
                }
            }
        });
        VariableSource dataModel = null;
        for (Object parentModel : this.parentModels) {
            if (!(parentModel instanceof DataWrapper)) continue;
            DataWrapper dataWrapper = (DataWrapper)parentModel;
            dataModel = dataWrapper.getSelectedDataModel();
        }
        if (dataModel == null) {
            throw new RuntimeException("Null Data Model");
        }
        this.varNames = new ArrayList<String>(dataModel.getVariableNames());
        if (dataModel instanceof CovarianceMatrix) {
            isDiscreteModel = false;
        } else {
            DataSet dataSet = (DataSet)dataModel;
            isDiscreteModel = dataSet.isDiscrete();
        }
        this.getParams().setVarNames(this.varNames);
        this.setBorder(new MatteBorder(10, 10, 10, 10, super.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        JPanel[] rows = new JPanel[5];
        for (int i = 0; i < 5; ++i) {
            rows[i] = new JPanel();
            rows[i].setBackground(super.getBackground());
        }
        if (isDiscreteModel) {
            msg0 = "Cell prior:";
            rows[0].setLayout(new FlowLayout(0));
            rows[0].setMaximumSize(new Dimension(1000, 30));
            rows[0].add(new JLabel(msg0));
            rows[0].add(cellPriorField);
            this.add(rows[0]);
            String msg1 = "Structure prior:";
            rows[1].setLayout(new FlowLayout(0));
            rows[1].setMaximumSize(new Dimension(1000, 30));
            rows[1].add(new JLabel(msg1));
            rows[1].add(structurePriorField);
            this.add(rows[1]);
        } else {
            msg0 = "BIC score will be used. No parameters to set.";
            rows[0].setLayout(new FlowLayout(0));
            rows[0].setMaximumSize(new Dimension(1000, 30));
            rows[0].add(new JLabel(msg0));
            this.add(rows[0]);
        }
        JButton knowledgeButton = new JButton("View Background Knowledge");
        rows[3].setLayout(new FlowLayout(0));
        rows[3].setMaximumSize(new Dimension(1000, 30));
        rows[3].add(knowledgeButton);
        this.add(rows[3]);
        knowledgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchParamGesEditor.this.openKnowledgeEditor();
            }
        });
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private void openKnowledgeEditor() {
        if (this.getParams() == null) {
            throw new NullPointerException("Parameter object must not be null if you want to launch a OldKnowledgeEditor.");
        }
        Knowledge knowledge = this.getParams().getKnowledge();
        KnowledgeEditor knowledgeEditor = new KnowledgeEditor(knowledge, this.varNames, this.getParams().getSourceGraph());
        EditorWindow window = new EditorWindow(knowledgeEditor, knowledgeEditor.getName(), "Save", false, this);
        DesktopController.getInstance().addEditorWindow(window, JLayeredPane.PALETTE_LAYER);
        window.setVisible(true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        this.name = name;
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private GesParams getParams() {
        return this.params;
    }

    private void setParams(GesParams params) {
        this.params = params;
    }
}

