/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemUpdater;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.SemEvidenceEditor;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.MatteBorder;

public class SemEvidenceWizardMultiple
extends JPanel {
    private SemUpdater semUpdater;
    private GraphWorkbench workbench;
    private final SemEvidenceEditor evidenceEditor;
    private JTextArea textArea = new JTextArea("Nothing to display");

    public SemEvidenceWizardMultiple(SemUpdater semUpdater, GraphWorkbench workbench) {
        if (semUpdater == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        this.semUpdater = semUpdater;
        this.workbench = workbench;
        workbench.setAllowDoubleClickActions(false);
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        JButton calcMarginalsAndJointButton = new JButton("Calculate Marginals and Joint");
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("<html>Select a set of nodes (by holding down the shift key) whose<br>marginals you would like to see given the evidence indicated<br>above.  Click the 'Calculate Marginals' button to view<br>marginals and log odds results."));
        b0.add(Box.createHorizontalGlue());
        this.add(b0);
        this.add(Box.createVerticalStrut(10));
        this.evidenceEditor = new SemEvidenceEditor(semUpdater.getEvidence());
        this.add(this.evidenceEditor);
        this.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.add(calcMarginalsAndJointButton);
        this.add(b2);
        this.add(Box.createVerticalGlue());
        calcMarginalsAndJointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<DisplayNode> selectedGraphNodes = SemEvidenceWizardMultiple.this.getWorkbench().getSelectedNodes();
                SemEvidenceWizardMultiple.this.getSemUpdater().setEvidence(SemEvidenceWizardMultiple.this.evidenceEditor.getEvidence());
                Graph updatedGraph = SemEvidenceWizardMultiple.this.getSemUpdater().getManipulatedGraph();
                SemEvidenceWizardMultiple.this.getWorkbench().setGraph(updatedGraph);
                LinkedList<Node> selectedNodes = new LinkedList<Node>();
                Iterator<DisplayNode> i$ = selectedGraphNodes.iterator();
                while (i$.hasNext()) {
                    DisplayNode displayNode;
                    DisplayNode graphNode = displayNode = i$.next();
                    Node tetradNode = graphNode.getModelNode();
                    String selectedNodeName = tetradNode.getName();
                    Node selectedNode = updatedGraph.getNode(selectedNodeName);
                    selectedNodes.add(selectedNode);
                }
                for (DisplayNode displayNode : selectedNodes) {
                    Node node = displayNode;
                    SemEvidenceWizardMultiple.this.getWorkbench().selectNode(node);
                }
                Collections.sort(selectedNodes, new Comparator<Node>(){

                    @Override
                    public int compare(Node o1, Node o2) {
                        String name1 = o1.getName();
                        String name2 = o2.getName();
                        return name1.compareTo(name2);
                    }
                });
                JTextArea marginalsArea = new JTextArea();
                marginalsArea.setEditable(false);
                NumberFormat numberFormat = NumberFormatUtil.getInstance().getNumberFormat();
                if (selectedNodes.size() == 0) {
                    marginalsArea.append("\nNo nodes selected.");
                }
                SemEvidenceWizardMultiple.this.textArea = marginalsArea;
                SemEvidenceWizardMultiple.this.firePropertyChange("updateButtonPressed", null, null);
            }
        });
    }

    public SemIm getSemIm() {
        return this.getSemUpdater().getUpdatedSemIm();
    }

    private SemUpdater getSemUpdater() {
        return this.semUpdater;
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }
}

