/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemUpdater;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.SemEvidenceEditor;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;

public class SemEvidenceWizardSingle
extends JPanel {
    private SemUpdater bayesUpdater;
    private GraphWorkbench workbench;
    private final SemEvidenceEditor evidenceEditor;

    public SemEvidenceWizardSingle(SemUpdater semUpdater, GraphWorkbench workbench) {
        if (semUpdater == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        Node node = workbench.getGraph().getNodes().get(0);
        workbench.deselectAll();
        workbench.selectNode(node);
        this.bayesUpdater = semUpdater;
        this.workbench = workbench;
        workbench.setAllowDoubleClickActions(false);
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        JButton updateButton = new JButton("Do Update Now");
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("<html>In the list below, specify values for variables you have evidence <br>for. Click the 'Do Update Now' button to view updated means. <br>(Other parameters remain the same.)."));
        b0.add(Box.createHorizontalGlue());
        this.add(b0);
        this.add(Box.createVerticalStrut(10));
        this.evidenceEditor = new SemEvidenceEditor(semUpdater.getEvidence());
        this.add(this.evidenceEditor);
        this.add(Box.createVerticalStrut(10));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        b2.add(updateButton);
        this.add(b2);
        this.add(Box.createVerticalGlue());
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayNode graphNode = SemEvidenceWizardSingle.this.getWorkbench().getSelectedNode();
                if (graphNode == null) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Please select exactly one node in the graph.");
                    return;
                }
                Node tetradNode = graphNode.getModelNode();
                String selectedNodeName = tetradNode.getName();
                SemEvidenceWizardSingle.this.getSemUpdater().setEvidence(SemEvidenceWizardSingle.this.evidenceEditor.getEvidence());
                Graph updatedGraph = SemEvidenceWizardSingle.this.getSemUpdater().getManipulatedGraph();
                Node selectedNode = updatedGraph.getNode(selectedNodeName);
                SemEvidenceWizardSingle.this.getWorkbench().setGraph(updatedGraph);
                SemEvidenceWizardSingle.this.getWorkbench().deselectAll();
                SemEvidenceWizardSingle.this.getWorkbench().selectNode(selectedNode);
                SemEvidenceWizardSingle.this.firePropertyChange("updateButtonPressed", null, null);
                SemEvidenceWizardSingle.this.firePropertyChange("modelChanged", null, null);
            }
        });
    }

    public SemIm getSemIm() {
        return this.getSemUpdater().getUpdatedSemIm();
    }

    private SemUpdater getSemUpdater() {
        return this.bayesUpdater;
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }
}

