/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetradapp.editor.DataCellEditor;
import edu.cmu.tetradapp.editor.ParamTableModel;
import edu.cmu.tetradapp.editor.SemImEditor;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;

final class SemImTabularEditor
extends JPanel {
    private ParamTableModel tableModel;
    private boolean editable = true;

    public SemImTabularEditor(ISemIm semIm, SemImEditor editor, int maxFreeParamsForStatistics) {
        this.setLayout(new BoxLayout(this, 1));
        if (semIm.isEstimated()) {
            this.setBorder(new TitledBorder("Null hypothesis for T and P is that the parameter is zero"));
        } else {
            this.setBorder(new TitledBorder("Click parameter values to edit"));
        }
        JTable table = new JTable(){

            @Override
            public TableCellEditor getCellEditor(int row, int col) {
                return new DataCellEditor();
            }
        };
        this.tableModel = new ParamTableModel(semIm, editor, maxFreeParamsForStatistics);
        table.setModel(this.getTableModel());
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SemImTabularEditor.this.firePropertyChange("modelChanged", null, null);
            }
        });
        this.add((Component)new JScrollPane(table), "Center");
    }

    public ParamTableModel getTableModel() {
        return this.tableModel;
    }

    public void setEditable(boolean editable) {
        this.tableModel.setEditable(editable);
        this.editable = editable;
        this.tableModel.fireTableStructureChanged();
    }

    public boolean isEditable() {
        return this.editable;
    }
}

