/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemEvidence;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemUpdater;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.SemImEditor;
import edu.cmu.tetradapp.model.SemUpdaterWrapper;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SemUpdaterEditor
extends JPanel {
    private SemUpdater semUpdater;
    private Map<JCheckBox, Integer> checkBoxesToVariables = new HashMap<JCheckBox, Integer>();
    private Map<Integer, JCheckBox> variablesToCheckboxes = new HashMap<Integer, JCheckBox>();
    private Map<Integer, DoubleTextField> variablesToTextFields = new HashMap<Integer, DoubleTextField>();
    private SemImEditor semImEditor;
    private LinkedList<DoubleTextField> focusTraversalOrder = new LinkedList();
    private Map<DoubleTextField, Integer> labels = new HashMap<DoubleTextField, Integer>();

    public SemUpdaterEditor(SemUpdater semUpdater) {
        if (semUpdater == null) {
            throw new NullPointerException("Bayes semUpdater must not be null.");
        }
        this.semUpdater = semUpdater;
        this.setLayout(new BorderLayout());
        this.setName("Bayes Updater Editor");
        Box b1 = Box.createHorizontalBox();
        this.semImEditor = new SemImEditor(semUpdater.getSemIm(), "Graphical View", "Tabular View");
        this.semImEditor.add((Component)this.getUpdatePanel(), "West");
        this.semImEditor.setEditable(false);
        b1.add(this.semImEditor);
        this.add((Component)b1, "Center");
    }

    private Box getUpdatePanel() {
        final SemEvidence evidence = this.semUpdater.getEvidence();
        this.focusTraversalOrder.clear();
        Box b = Box.createVerticalBox();
        Box b0 = Box.createHorizontalBox();
        b0.add(new JLabel("<html>In the list below, specify values for variables you have evidence <br>for. Click the 'Do Update Now' button to view updated model."));
        b0.add(Box.createHorizontalGlue());
        b.add(b0);
        b.add(Box.createVerticalStrut(10));
        Box d = Box.createHorizontalBox();
        d.add(new JLabel("Variable = value"));
        d.add(Box.createHorizontalGlue());
        d.add(new JLabel("Manipulated"));
        b.add(d);
        for (int i = 0; i < evidence.getNumNodes(); ++i) {
            Box c = Box.createHorizontalBox();
            SemIm semIm = evidence.getSemIm();
            Node node = semIm.getVariableNodes().get(i);
            String name = node.getName();
            JLabel label = new JLabel(name + " =  "){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            c.add(label);
            double mean = evidence.getProposition().getValue(i);
            final DoubleTextField field = new DoubleTextField(mean, 5, NumberFormatUtil.getInstance().getNumberFormat());
            field.setFilter(new DoubleTextField.Filter(){

                @Override
                public double filter(double value, double oldValue) {
                    try {
                        int nodeIndex = (Integer)SemUpdaterEditor.this.labels.get(field);
                        if (Double.isNaN(value) && evidence.isManipulated(nodeIndex)) {
                            throw new IllegalArgumentException();
                        }
                        evidence.getProposition().setValue(nodeIndex, value);
                        SemIm updatedSem = SemUpdaterEditor.this.semUpdater.getUpdatedSemIm();
                        SemUpdaterEditor.this.semImEditor.setSemIm(updatedSem, SemUpdaterEditor.this.semImEditor.getTabSelectionIndex(), SemUpdaterEditor.this.semImEditor.getMatrixSelection());
                        return value;
                    }
                    catch (IllegalArgumentException e) {
                        return oldValue;
                    }
                }
            });
            this.labels.put(field, i);
            this.variablesToTextFields.put(i, field);
            this.focusTraversalOrder.add(field);
            c.add(field);
            c.add(Box.createHorizontalStrut(2));
            c.add(Box.createHorizontalGlue());
            JCheckBox checkbox = new JCheckBox(){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            checkbox.setSelected(evidence.isManipulated(i));
            this.checkBoxesToVariables.put(checkbox, i);
            this.variablesToCheckboxes.put(i, checkbox);
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBox checkbox = (JCheckBox)e.getSource();
                    boolean selected = checkbox.isSelected();
                    Integer o = (Integer)SemUpdaterEditor.this.checkBoxesToVariables.get(checkbox);
                    double value = evidence.getProposition().getValue(o);
                    if (Double.isNaN(value)) {
                        DoubleTextField field = (DoubleTextField)SemUpdaterEditor.this.variablesToTextFields.get(o);
                        SemIm semIm = SemUpdaterEditor.this.semUpdater.getSemIm();
                        Node node = semIm.getVariableNodes().get(o);
                        double mean = semIm.getMean(node);
                        field.setValue(mean);
                    }
                    SemUpdaterEditor.this.semUpdater.getEvidence().setManipulated(o, selected);
                    SemIm updatedSem = SemUpdaterEditor.this.semUpdater.getUpdatedSemIm();
                    SemUpdaterEditor.this.semImEditor.setSemIm(updatedSem, SemUpdaterEditor.this.semImEditor.getTabSelectionIndex(), SemUpdaterEditor.this.semImEditor.getMatrixSelection());
                }
            });
            checkbox.setBackground(Color.WHITE);
            checkbox.setBorder(null);
            c.add(checkbox);
            c.setMaximumSize(new Dimension(1000, 30));
            b.add(c);
        }
        b.add(Box.createVerticalGlue());
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalGlue());
        JButton button = new JButton("Do Update Now");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SemIm updatedSem = SemUpdaterEditor.this.semUpdater.getUpdatedSemIm();
                SemUpdaterEditor.this.semImEditor.setSemIm(updatedSem, SemUpdaterEditor.this.semImEditor.getTabSelectionIndex(), SemUpdaterEditor.this.semImEditor.getMatrixSelection());
            }
        });
        b2.add(button);
        b.add(b2);
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                int index = SemUpdaterEditor.this.focusTraversalOrder.indexOf(aComponent);
                int size = SemUpdaterEditor.this.focusTraversalOrder.size();
                if (index != -1) {
                    return (Component)SemUpdaterEditor.this.focusTraversalOrder.get((index + 1) % size);
                }
                return this.getFirstComponent(focusCycleRoot);
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                int index = SemUpdaterEditor.this.focusTraversalOrder.indexOf(aComponent);
                int size = SemUpdaterEditor.this.focusTraversalOrder.size();
                if (index != -1) {
                    return (Component)SemUpdaterEditor.this.focusTraversalOrder.get((index - 1) % size);
                }
                return this.getFirstComponent(focusCycleRoot);
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return (Component)SemUpdaterEditor.this.focusTraversalOrder.getFirst();
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return (Component)SemUpdaterEditor.this.focusTraversalOrder.getLast();
            }

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return this.getFirstComponent(focusCycleRoot);
            }
        });
        this.setFocusCycleRoot(true);
        return b;
    }

    public SemUpdaterEditor(SemUpdaterWrapper wrapper) {
        this(wrapper.getSemUpdater());
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }
}

