/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class SplitByCollinearColumnsAction
extends AbstractAction {
    private DataEditor dataEditor;

    public SplitByCollinearColumnsAction(DataEditor editor) {
        super("Split Data by Collinear Columns");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CorrelationMatrix corrMatrix;
        DataModel dataModel = this.getDataEditor().getSelectedDataModel();
        if (dataModel instanceof DataSet) {
            try {
                DataSet dataSet = (DataSet)dataModel;
                CovarianceMatrix covMatrix = new CovarianceMatrix(dataSet);
                corrMatrix = new CorrelationMatrix(covMatrix);
            }
            catch (Exception e1) {
                String message = e1.getMessage();
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), message);
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
        } else if (dataModel instanceof CovarianceMatrix) {
            corrMatrix = new CorrelationMatrix((CovarianceMatrix)dataModel);
        } else {
            String message = "Operation not supported for this kind of data set.";
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), message);
            throw new RuntimeException(message);
        }
        CollinearityChooser collinearityChooser = new CollinearityChooser(this.dataEditor);
        int selection = JOptionPane.showOptionDialog(JOptionUtils.centeringComp(), collinearityChooser, "Degree of collinearity", 0, 3, null, new String[]{"Done", "Cancel"}, "Done");
        if (selection == 0 && this.confirmSplit(corrMatrix, dataModel, (double)collinearityChooser.getCorrelationSize() / 100.0)) {
            DataModelList splitData = new DataModelList();
            DataModelList splitData1 = this.getSplitData(corrMatrix, dataModel, (double)collinearityChooser.getCorrelationSize() / 100.0, splitData);
            this.getDataEditor().reset(splitData1);
        }
    }

    private boolean confirmSplit(CorrelationMatrix corrMatrix, DataModel dataModel, double correlation) {
        int count = 0;
        for (int i = 0; i < dataModel.getVariableNames().size() - 1; ++i) {
            int index1 = this.getMatrixIndex(corrMatrix, dataModel.getVariableNames().get(i));
            for (int j = i + 1; j < dataModel.getVariableNames().size(); ++j) {
                int index2 = this.getMatrixIndex(corrMatrix, dataModel.getVariableNames().get(j));
                if (!(Math.abs(corrMatrix.getValue(index1, index2)) > correlation)) continue;
                ++count;
            }
        }
        if (count == 0) {
            return false;
        }
        int total = (int)Math.pow(2.0, count);
        int selection = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This option will generate " + total + " extra data sets. Continue?", "Confirmation", 0);
        return selection == 0;
    }

    private int getMatrixIndex(CorrelationMatrix corrMatrix, String key) {
        for (int i = 0; i < corrMatrix.getVariableNames().size(); ++i) {
            if (!corrMatrix.getVariableNames().get(i).equals(key)) continue;
            return i;
        }
        return -1;
    }

    private DataModelList getSplitData(CorrelationMatrix corrMatrix, DataModel dataModel, double correlation, DataModelList modelList) {
        int index1 = -1;
        int index2 = -1;
        boolean found = false;
        for (int i = 0; i < dataModel.getVariableNames().size() - 1 && !found; ++i) {
            int index_i = this.getMatrixIndex(corrMatrix, dataModel.getVariableNames().get(i));
            index1 = i;
            for (int j = i + 1; j < dataModel.getVariableNames().size() && !found; ++j) {
                int index_j = this.getMatrixIndex(corrMatrix, dataModel.getVariableNames().get(j));
                index2 = j;
                if (!(Math.abs(corrMatrix.getValue(index_i, index_j)) > correlation)) continue;
                found = true;
            }
        }
        if (found) {
            if (dataModel instanceof DataSet) {
                ((DataSet)dataModel).removeColumn(index2);
                ((DataSet)dataModel).removeColumn(index1);
                this.getSplitData(corrMatrix, dataModel, correlation, modelList);
                this.getSplitData(corrMatrix, dataModel, correlation, modelList);
            } else {
                String[] subVarNames1 = new String[dataModel.getVariableNames().size() - 1];
                String[] subVarNames2 = new String[dataModel.getVariableNames().size() - 1];
                int count1 = 0;
                int count2 = 0;
                for (int i = 0; i < dataModel.getVariableNames().size(); ++i) {
                    if (i != index2) {
                        subVarNames1[count1++] = dataModel.getVariableNames().get(i);
                    }
                    if (i == index1) continue;
                    subVarNames2[count2++] = dataModel.getVariableNames().get(i);
                }
                CovarianceMatrix newDataModel1 = ((CovarianceMatrix)dataModel).getSubmatrix(subVarNames1);
                CovarianceMatrix newDataModel2 = ((CovarianceMatrix)dataModel).getSubmatrix(subVarNames2);
                this.getSplitData(corrMatrix, newDataModel1, correlation, modelList);
                this.getSplitData(corrMatrix, newDataModel2, correlation, modelList);
            }
        } else {
            modelList.add(dataModel);
        }
        return modelList;
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }

    private static final class CollinearityChooser
    extends JComponent {
        private int correlationSize = 95;

        public CollinearityChooser(DataEditor editor) {
            this.setLayout(new BorderLayout());
            Box b1 = Box.createVerticalBox();
            Box b2 = Box.createHorizontalBox();
            JLabel l1 = new JLabel("Correlation threshold (x 100):");
            l1.setForeground(Color.black);
            b2.add(l1);
            b2.add(Box.createGlue());
            IntTextField correlationSizeField = new IntTextField(95, 3);
            correlationSizeField.setFilter(new IntTextField.Filter(){

                @Override
                public int filter(int value, int oldValue) {
                    if (value < 80 || value > 100) {
                        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Correlation threshold should be in the [80, 100] interval", "Alert", 0);
                        return oldValue;
                    }
                    CollinearityChooser.this.correlationSize = value;
                    return value;
                }
            });
            b2.add(correlationSizeField);
            b1.add(b2);
            this.add((Component)b1, "Center");
        }

        public int getCorrelationSize() {
            return this.correlationSize;
        }
    }
}

