/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public final class SplitCasesAction
extends AbstractAction {
    private DataEditor dataEditor;

    public SplitCasesAction(DataEditor editor) {
        super("Split Data by Cases");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel selectedDataModel = this.getDataEditor().getSelectedDataModel();
        if (!(selectedDataModel instanceof DataSet)) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Requires a tabular data set.");
        }
        LinkedList<Node> selectedVariables = new LinkedList<Node>();
        DataSet dataSet = (DataSet)selectedDataModel;
        int numColumns = dataSet.getNumColumns();
        for (int i = 0; i < numColumns; ++i) {
            Node variable = dataSet.getVariable(i);
            if (!dataSet.isSelected(variable)) continue;
            selectedVariables.add(variable);
        }
        if (dataSet.getNumRows() == 0) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Data set is empty.");
            return;
        }
        if (selectedVariables.isEmpty()) {
            selectedVariables.addAll(dataSet.getVariables());
        }
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }
}

