/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Variable;
import edu.cmu.tetrad.graph.Node;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.table.AbstractTableModel;

class TabularDataTable
extends AbstractTableModel {
    private DataSet dataSet;
    private int numLeadingRows = 2;
    private int numLeadingCols = 2;
    private boolean categoryNamesShown = true;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public TabularDataTable(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public String getColumnName(int col) {
        return null;
    }

    @Override
    public int getRowCount() {
        int maxRowCount = this.dataSet.getNumRows() + 3;
        return maxRowCount < 100 ? 100 : maxRowCount;
    }

    @Override
    public int getColumnCount() {
        return this.dataSet.getNumColumns() < 30 ? 30 : this.dataSet.getNumColumns() + this.getNumLeadingCols() + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int columnIndex = col - this.getNumLeadingCols();
        int rowIndex = row - 2;
        if (col == 1) {
            if (row == 1) {
                return "MULT";
            }
            if (rowIndex >= 0 && rowIndex < this.dataSet.getNumRows()) {
                return this.dataSet.getMultiplier(rowIndex);
            }
        } else {
            if (col >= this.getNumLeadingCols() && col < this.dataSet.getNumColumns() + this.getNumLeadingCols()) {
                Object value;
                Node variable = this.dataSet.getVariable(columnIndex);
                if (row == 0) {
                    boolean discrete = variable instanceof DiscreteVariable;
                    return "C" + Integer.toString(columnIndex + 1) + (discrete ? "-T" : "");
                }
                if (row == 1) {
                    return this.dataSet.getVariable(columnIndex).getName();
                }
                if (rowIndex >= this.dataSet.getNumRows()) {
                    return null;
                }
                if (variable instanceof DiscreteVariable) {
                    ((DiscreteVariable)variable).setCategoryNamesDisplayed(this.isCategoryNamesShown());
                }
                if (((Variable)variable).isMissingValue(value = this.dataSet.getObject(rowIndex, columnIndex))) {
                    return "*";
                }
                return value;
            }
            if (col >= this.dataSet.getNumColumns() + this.getNumLeadingCols() && row == 0) {
                return "C" + Integer.toString(columnIndex + 1);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return row > 0 && col >= 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            throw new IllegalArgumentException("Bad col index: " + col);
        }
        if (col == 1) {
            if (row >= 2) {
                try {
                    int multiplier = new Integer((String)value);
                    this.dataSet.setMultiplier(row - 2, multiplier);
                }
                catch (Exception e) {
                    this.dataSet.setMultiplier(row - 2, 1);
                }
            }
        } else if (col >= this.getNumLeadingCols() && col < this.dataSet.getNumColumns() + this.getNumLeadingCols()) {
            if (row == 1) {
                this.setColumnName(col, value);
            } else if (row > 1) {
                try {
                    this.pasteIntoColumn(row, col, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.pcs.firePropertyChange("modelChanged", null, null);
                    return;
                }
            }
        } else {
            this.addColumnsOutTo(col);
            if (row == 1) {
                this.setColumnName(col, this.newColumnName((String)value));
            } else if (row > 1) {
                try {
                    this.pasteIntoColumn(row, col, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.pcs.firePropertyChange("modelChanged", null, null);
                    return;
                }
            }
        }
        this.fireTableDataChanged();
        this.pcs.firePropertyChange("modelChanged", null, null);
    }

    private void addColumnsOutTo(int col) {
        for (int i = this.dataSet.getNumColumns() + this.getNumLeadingCols(); i <= col; ++i) {
            ContinuousVariable var = new ContinuousVariable("");
            this.dataSet.addVariable(var);
            System.out.println("Adding " + var + " col " + this.dataSet.getColumn(var));
        }
        this.pcs.firePropertyChange("modelChanged", null, null);
    }

    private String newColumnName(String suggestedName) {
        String proposedName;
        if (!this.existsColByName(suggestedName)) {
            return suggestedName;
        }
        int i = 0;
        while (this.existsColByName(proposedName = suggestedName + "-" + ++i)) {
        }
        return proposedName;
    }

    private boolean existsColByName(String proposedName) {
        for (int i = 0; i < this.dataSet.getNumColumns(); ++i) {
            String name = this.dataSet.getVariable(i).getName();
            if (!name.equals(proposedName)) continue;
            return true;
        }
        return false;
    }

    private void setColumnName(int col, Object value) {
        this.dataSet.getVariable(col - this.getNumLeadingCols()).setName((String)value);
        this.pcs.firePropertyChange("modelChanged", null, null);
    }

    private void pasteIntoColumn(int row, int col, Object value) {
        int dataRow = row - this.getNumLeadingRows();
        int dataCol = col - this.getNumLeadingCols();
        Node variable = this.dataSet.getVariable(dataCol);
        if (variable instanceof ContinuousVariable && value instanceof Number) {
            this.dataSet.setObject(dataRow, dataCol, value);
            return;
        }
        if ("".equals(value) || value == null) {
            return;
        }
        String valueTrimmed = ((String)value).trim();
        boolean quoted = false;
        if (valueTrimmed.startsWith("\"") && valueTrimmed.endsWith("\"")) {
            value = valueTrimmed.substring(1, valueTrimmed.length() - 1);
            quoted = true;
        }
        if (!(variable instanceof DiscreteVariable) && this.isEmpty(this.dataSet, dataCol) && (quoted || !this.isNumber((String)value))) {
            variable = this.swapDiscreteColumnForContinuous(col);
        }
        if (value instanceof String && ((String)value).trim().equals("*")) {
            value = ((Variable)variable).getMissingValueMarker();
        }
        this.dataSet.setObject(dataRow, dataCol, value);
        this.pcs.firePropertyChange("modelChanged", null, null);
    }

    private boolean isEmpty(DataSet dataSet, int column) {
        Node variable = dataSet.getVariable(column);
        Object missingValue = ((Variable)variable).getMissingValueMarker();
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            if (dataSet.getObject(i, column).equals(missingValue)) continue;
            return false;
        }
        return true;
    }

    private Node swapDiscreteColumnForContinuous(int col) {
        Node variable = this.dataSet.getVariable(col - this.getNumLeadingCols());
        if (variable == null) {
            throw new NullPointerException();
        }
        if (!this.isEmpty(this.dataSet, col - this.getNumLeadingCols())) {
            throw new IllegalArgumentException("Old column not empty.");
        }
        String name = variable.getName();
        DiscreteVariable var = new DiscreteVariable(name);
        var.setCategoryNamesDisplayed(true);
        this.dataSet.removeColumn(col - this.getNumLeadingCols());
        this.dataSet.addVariable(col - this.getNumLeadingCols(), var);
        this.pcs.firePropertyChange("modelChanged", null, null);
        return var;
    }

    private boolean isNumber(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet data) {
        if (data == null) {
            throw new NullPointerException("Data set was null.");
        }
        this.dataSet = data;
    }

    private int getNumLeadingRows() {
        return this.numLeadingRows;
    }

    private int getNumLeadingCols() {
        return this.numLeadingCols;
    }

    public void setCategoryNamesShown(boolean selected) {
        this.categoryNamesShown = selected;
        this.fireTableDataChanged();
    }

    public boolean isCategoryNamesShown() {
        return this.categoryNamesShown;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }
}

