/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetradapp.editor.TierList;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class Tier
extends JPanel {
    private TierList knowList;
    private int num;
    private String[] tierNames;
    private JPanel view = new JPanel();
    private JScrollPane jsp = new JScrollPane(21, 30);
    private static Knowledge know;

    public Tier(TierList kn, int thisTier, String[] tierNames) {
        this.knowList = kn;
        this.num = thisTier;
        this.tierNames = tierNames;
        this.setLayout(new BoxLayout(this, 0));
        this.jsp.setViewportView(this.view);
    }

    public static void setKnowledge(Knowledge k) {
        know = k;
    }

    public void loadInfo() {
        this.removeAll();
        this.view.removeAll();
        this.add(new JLabel("Tier " + this.num));
        this.add(this.jsp);
        List<String> t = know.getTier(this.num);
        this.view.setLayout(new BoxLayout(this.view, 0));
        for (String temp : t) {
            String[] names = new String[this.tierNames.length + 1];
            names[0] = temp;
            System.arraycopy(this.tierNames, 0, names, 1, this.tierNames.length);
            JComboBox<String> cBox = new JComboBox<String>(names);
            cBox.setMaximumSize(new Dimension(80, 50));
            this.view.add(cBox);
            cBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox cb = (JComboBox)e.getSource();
                    int newTier = cb.getSelectedIndex() - 2;
                    String s = (String)cb.getItemAt(0);
                    if (newTier == -2) {
                        return;
                    }
                    know.removeFromTiers(s);
                    if (newTier >= 0) {
                        know.addToTier(newTier, s);
                    }
                    Tier.this.knowList.refreshInfo();
                }
            });
        }
    }

    public void setUnspecified(List<String> varNames) {
        this.removeAll();
        this.view.removeAll();
        this.add(new JLabel("Unspecified"));
        this.add(this.jsp);
        LinkedList<String> vNames = new LinkedList<String>(varNames);
        System.out.println("edit unspecified list");
        System.out.println("vNames Contains: " + vNames);
        for (int i = 0; i < know.getNumTiers(); ++i) {
            System.out.println("Tier " + i);
            List<String> t = know.getTier(i);
            System.out.println("Tier contains: " + t);
            for (String temp : t) {
                System.out.println("Try removing: " + temp);
                vNames.remove(temp);
            }
        }
        System.out.println("vNames now Contains: " + vNames);
        this.view.setLayout(new BoxLayout(this.view, 0));
        for (String temp : vNames) {
            String[] names = new String[this.tierNames.length + 1];
            names[0] = temp;
            System.arraycopy(this.tierNames, 0, names, 1, this.tierNames.length);
            JComboBox<String> cBox = new JComboBox<String>(names);
            cBox.setMaximumSize(new Dimension(80, 50));
            this.view.add(cBox);
            cBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox cb = (JComboBox)e.getSource();
                    int newTier = cb.getSelectedIndex() - 2;
                    String s = (String)cb.getItemAt(0);
                    if (newTier == -2) {
                        return;
                    }
                    know.removeFromTiers(s);
                    if (newTier >= 0) {
                        know.addToTier(newTier, s);
                    }
                    Tier.this.knowList.refreshInfo();
                }
            });
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1000, 60);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(250, 60);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(2000, 60);
    }
}

