/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetradapp.editor.TemporalTierEditor;
import edu.cmu.tetradapp.editor.Tier;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TierList
extends JScrollPane {
    private Knowledge knowledge;
    private JPanel constList = new JPanel();
    private TemporalTierEditor tierListEditor;
    private List<String> vNames;
    private Tier[] tiers;

    public TierList(Knowledge know, List<String> varNames, TemporalTierEditor tierListEditor) {
        super(20, 30);
        this.vNames = varNames;
        if (know == null) {
            throw new NullPointerException("Knowledge must not be null.");
        }
        if (varNames == null) {
            throw new NullPointerException("AbstractVariable name list must not be null.");
        }
        if (tierListEditor == null) {
            throw new NullPointerException("TierListEditor must not be null.");
        }
        this.tierListEditor = tierListEditor;
        this.setViewportView(this.constList);
        System.out.println("TierList Knowledge is: " + know);
        if (know == null) {
            throw new NullPointerException();
        }
        this.knowledge = know;
        this.constList.setLayout(new BoxLayout(this.constList, 1));
        String[] names = varNames.toArray(new String[0]);
        String[] tierNames = new String[names.length + 1];
        tierNames[0] = "Unspecified";
        for (int i = 0; i < names.length; ++i) {
            tierNames[i + 1] = "Tier " + i;
        }
        this.tiers = new Tier[names.length + 1];
        Tier.setKnowledge(this.knowledge);
        this.tiers[names.length] = new Tier(this, -1, tierNames);
        Box b = Box.createHorizontalBox();
        b.add(this.tiers[names.length]);
        this.constList.add(b);
        for (int i = 0; i < names.length; ++i) {
            this.tiers[i] = new Tier(this, i, tierNames);
            Box b1 = Box.createHorizontalBox();
            b1.add(this.tiers[i]);
            this.constList.add(b1);
        }
        this.refreshInfo();
    }

    public void refreshInfo() {
        this.tiers[this.tiers.length - 1].setUnspecified(this.vNames);
        this.tiers[this.tiers.length - 1].repaint();
        this.tiers[this.tiers.length - 1].validate();
        for (int i = 0; i < this.tiers.length - 1; ++i) {
            this.tiers[i].loadInfo();
            this.tiers[i].repaint();
            this.tiers[i].validate();
        }
        this.repaint();
        this.validate();
        this.tierListEditor.repaint();
        this.tierListEditor.validate();
        this.repaint();
        this.validate();
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }
}

