/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetradapp.gene.editor.BooleanTable;
import edu.cmu.tetradapp.gene.editor.ErrorsTable;
import edu.cmu.tetradapp.model.BooleanGlassGeneIm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BooleanGlassGeneImEditor
extends JPanel
implements PropertyChangeListener {
    private JTextField decayRateField;
    private JTextField booleanInfluenceRateField;
    private JTable booleansTable;
    private BooleanGlassGeneIm im;

    public BooleanGlassGeneImEditor(BooleanGlassGeneIm im) {
        this.im = im;
        this.setLayout(new BorderLayout());
        JPanel booleansPanel = new JPanel();
        booleansPanel.setLayout(new BorderLayout());
        JPanel varsPanel = new JPanel();
        varsPanel.setLayout(new BorderLayout());
        varsPanel.add((Component)new Label("Vars"), "North");
        ArrayList<String> displayFactors = new ArrayList<String>();
        List<String> modelFactors = im.getFactors();
        for (String modelFactor : modelFactors) {
            displayFactors.add(modelFactor + ":L0");
        }
        JList<Object> varList = new JList<Object>(displayFactors.toArray());
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionMode(0);
        varList.setSelectionModel(selectionModel);
        varsPanel.add((Component)new JScrollPane(varList), "Center");
        varList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    JList theList = (JList)e.getSource();
                    int index = theList.getSelectedIndex();
                    BooleanGlassGeneImEditor.this.updateBooleanTable(index);
                }
            }
        });
        booleansPanel.add((Component)varsPanel, "West");
        this.booleansTable = new JTable(new ErrorsTable(im));
        this.booleansTable.getTableHeader().setReorderingAllowed(false);
        this.booleansTable.getTableHeader().setResizingAllowed(false);
        this.booleansTable.setAutoResizeMode(0);
        booleansPanel.add((Component)new JScrollPane(this.booleansTable), "Center");
        JPanel errorsPanel = new JPanel();
        errorsPanel.setLayout(new BorderLayout());
        JTable errorsTable = new JTable(new ErrorsTable(im));
        errorsTable.getTableHeader().setReorderingAllowed(false);
        errorsTable.getTableHeader().setResizingAllowed(false);
        errorsTable.setAutoResizeMode(0);
        errorsPanel.add((Component)new JScrollPane(errorsTable), "Center");
        errorsPanel.add((Component)new JScrollPane(errorsTable), "Center");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Booleans", booleansPanel);
        tabbedPane.addTab("Errors", errorsPanel);
        this.add((Component)tabbedPane, "Center");
        JLabel decayRateLabel = new JLabel("DecayRate = ");
        decayRateLabel.setForeground(Color.black);
        this.decayRateField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 0);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(100, 100);
            }
        };
        this.decayRateField.setHorizontalAlignment(4);
        this.decayRateField.setText(Double.toString(im.getBooleanGlassFunction().getDecayRate()));
        this.decayRateField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newValue = e.getActionCommand();
                try {
                    double d = Double.parseDouble(newValue);
                    BooleanGlassGeneImEditor.this.getBooleanGlassGeneIm().getBooleanGlassFunction().setDecayRate(d);
                }
                catch (Exception e2) {
                    double decayRate = BooleanGlassGeneImEditor.this.getBooleanGlassGeneIm().getBooleanGlassFunction().getDecayRate();
                    BooleanGlassGeneImEditor.this.decayRateField.setText(Double.toString(decayRate));
                }
            }
        });
        JLabel booleanInfluenceRateLabel = new JLabel("BooleanInfluenceRate = ");
        booleanInfluenceRateLabel.setForeground(Color.black);
        this.booleanInfluenceRateField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 0);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(100, 100);
            }
        };
        this.booleanInfluenceRateField.setHorizontalAlignment(4);
        double booleanInfluenceRate = im.getBooleanGlassFunction().getBooleanInfluenceRate();
        this.booleanInfluenceRateField.setText(Double.toString(booleanInfluenceRate));
        this.booleanInfluenceRateField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newValue = e.getActionCommand();
                try {
                    double d = Double.parseDouble(newValue);
                    BooleanGlassGeneImEditor.this.getBooleanGlassGeneIm().getBooleanGlassFunction().setBooleanInfluenceRate(d);
                }
                catch (Exception e2) {
                    double _booleanInfluenceRate = BooleanGlassGeneImEditor.this.getBooleanGlassGeneIm().getBooleanGlassFunction().getBooleanInfluenceRate();
                    BooleanGlassGeneImEditor.this.booleanInfluenceRateField.setText(Double.toString(_booleanInfluenceRate));
                }
            }
        });
        Box lowerBox = Box.createHorizontalBox();
        lowerBox.add(Box.createHorizontalStrut(30));
        lowerBox.add(decayRateLabel);
        lowerBox.add(this.decayRateField);
        lowerBox.add(Box.createHorizontalStrut(30));
        lowerBox.add(booleanInfluenceRateLabel);
        lowerBox.add(this.booleanInfluenceRateField);
        lowerBox.add(Box.createHorizontalStrut(20));
        lowerBox.add(Box.createHorizontalGlue());
        this.add((Component)lowerBox, "South");
        varList.setSelectedIndex(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("editorClosing".equals(e.getPropertyName())) {
            this.firePropertyChange("editorClosing", null, this.getName());
        }
    }

    private void updateBooleanTable(int factorIndex) {
        this.booleansTable.setModel(new BooleanTable(factorIndex, this.im));
    }

    private BooleanGlassGeneIm getBooleanGlassGeneIm() {
        return this.im;
    }
}

