/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.gene.graph.ActiveLagGraph;
import edu.cmu.tetrad.gene.history.LaggedEdge;
import edu.cmu.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetradapp.gene.editor.LagGraphWorkbench;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class GraphTableWorkbench
extends JTable
implements LagGraphWorkbench {
    public static final String BASE_FACTOR_NAME = "Gene";
    protected JTable table = this;
    private boolean allowUserEditing;

    public GraphTableWorkbench(ActiveLagGraph lagGraph) {
        this.table.setModel(new LagGraphTableModel(lagGraph));
    }

    @Override
    public ActiveLagGraph getModelGraph() {
        return ((LagGraphTableModel)this.table.getModel()).getModelGraph();
    }

    @Override
    public void setModelGraph(ActiveLagGraph modelGraph) {
        ((LagGraphTableModel)this.table.getModel()).setModelGraph(modelGraph);
    }

    public void newFactor() {
        String name = this.nextVariableName(BASE_FACTOR_NAME);
        this.getModelGraph().addFactor(name);
        LaggedFactor toSelf = new LaggedFactor(name, 1);
        this.getModelGraph().addEdge(name, toSelf);
    }

    public void clearFactors() {
        LagGraphTableModel m = (LagGraphTableModel)this.table.getModel();
        int[] selection = this.getSelectedRows();
        LinkedList<String> toRemove = new LinkedList<String>();
        for (int i = 0; i < selection.length; ++i) {
            toRemove.add(m.getRowFactor(selection[i]));
        }
        Iterator it = toRemove.iterator();
        while (it.hasNext()) {
            m.getModelGraph().removeFactor((String)it.next());
        }
    }

    public String nextVariableName(String base) {
        int i = 0;
        String name = null;
        do {
            name = base + ++i;
        } while (this.getModelGraph().existsFactor(name));
        return name;
    }

    public boolean getAllowUserEditing() {
        return this.allowUserEditing;
    }

    protected class LagGraphTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        ActiveLagGraph sourceGraph;
        List factors;

        public LagGraphTableModel(ActiveLagGraph sourceGraph) {
            this.setModelGraph(sourceGraph);
        }

        public void addFactor(String name) {
            this.factors = new ArrayList<String>(this.getModelGraph().getFactors());
            int newRowIndex = this.factors.size() - 1;
            this.fireTableStructureChanged();
            this.fireTableRowsInserted(newRowIndex, newRowIndex);
        }

        public void removeFactor(String name) {
            int index = this.factors.indexOf(name);
            this.factors = new ArrayList<String>(this.getModelGraph().getFactors());
            this.fireTableStructureChanged();
            this.fireTableRowsDeleted(index, index);
        }

        public void renameFactor(String oldName) {
            int index = this.factors.indexOf(oldName);
            this.factors = new ArrayList<String>(this.getModelGraph().getFactors());
            this.fireTableStructureChanged();
            this.fireTableRowsUpdated(index, index);
        }

        public void setModelGraph(ActiveLagGraph sourceGraph) {
            if (this.getModelGraph() != null) {
                this.getModelGraph().removePropertyChangeListener(this);
            }
            this.sourceGraph = sourceGraph;
            if (sourceGraph != null) {
                this.factors = new ArrayList<String>(this.getModelGraph().getFactors());
                this.getModelGraph().addPropertyChangeListener(this);
                this.fireTableStructureChanged();
                this.fireTableRowsInserted(0, this.factors.size() - 1);
            }
        }

        public ActiveLagGraph getModelGraph() {
            return this.sourceGraph;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Source Factors";
            }
            return "-> " + this.factors.get(col - 1);
        }

        public String getRowFactor(int row) {
            return (String)this.factors.get(row);
        }

        @Override
        public int getRowCount() {
            return this.factors.size();
        }

        @Override
        public int getColumnCount() {
            return this.factors.size() + 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.factors.get(row);
            }
            String factor = (String)this.factors.get(--col);
            SortedSet parents = this.getModelGraph().getParents(factor);
            String sourceFactor = (String)this.factors.get(row);
            Iterator it = parents.iterator();
            TreeSet<Integer> lags = new TreeSet<Integer>();
            while (it.hasNext()) {
                LaggedFactor lf = (LaggedFactor)it.next();
                if (!sourceFactor.equals(lf.getFactor())) continue;
                lags.add(lf.getLag());
            }
            String ret = "";
            it = lags.iterator();
            if (it.hasNext()) {
                ret = it.next().toString();
            }
            while (it.hasNext()) {
                ret = ret + ", " + it.next().toString();
            }
            return ret;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this.getModelGraph().renameFactor((String)this.getValueAt(row, col), (String)value);
            } else {
                TreeSet<LaggedFactor> toCreate = new TreeSet<LaggedFactor>();
                String sourceFactor = (String)this.factors.get(row);
                String destFactor = (String)this.factors.get(--col);
                StringTokenizer parser = new StringTokenizer(value.toString(), ", ");
                while (parser.hasMoreTokens()) {
                    try {
                        int lag = Integer.parseInt(parser.nextToken());
                        toCreate.add(new LaggedFactor(sourceFactor, lag));
                    }
                    catch (NumberFormatException e) {}
                }
                TreeSet toRemove = new TreeSet(this.getModelGraph().getParents(destFactor));
                Iterator it = toRemove.iterator();
                while (it.hasNext()) {
                    LaggedFactor lf = (LaggedFactor)it.next();
                    if (lf.getFactor().equals(sourceFactor)) continue;
                    it.remove();
                }
                TreeSet toKeep = new TreeSet(toCreate);
                toCreate.removeAll(toRemove);
                toRemove.removeAll(toKeep);
                it = toRemove.iterator();
                while (it.hasNext()) {
                    this.getModelGraph().removeEdge(destFactor, (LaggedFactor)it.next());
                }
                it = toCreate.iterator();
                while (it.hasNext()) {
                    this.getModelGraph().addEdge(destFactor, (LaggedFactor)it.next());
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            Object old = e.getOldValue();
            Object _new = e.getNewValue();
            if (propName.equals("nodeAdded")) {
                this.addFactor((String)_new);
            } else if (propName.equals("nodeRemoved")) {
                this.removeFactor((String)old);
            } else if (propName.equals("edgeAdded")) {
                LaggedEdge le = (LaggedEdge)_new;
                int row = this.factors.indexOf(le.getFactor());
                int col = this.factors.indexOf(le.getLaggedFactor().getFactor()) + 1;
                this.fireTableCellUpdated(row, col);
            } else if (propName.equals("edgeRemoved")) {
                LaggedEdge le = (LaggedEdge)old;
                int row = this.factors.indexOf(le.getFactor());
                int col = this.factors.indexOf(le.getLaggedFactor().getFactor()) + 1;
                this.fireTableCellUpdated(row, col);
            } else if (propName.equals("edgeLaunch")) {
                System.out.println("Attempt to launch edge.");
            } else if (propName.equals("factorRenamed")) {
                this.renameFactor((String)old);
            }
        }
    }
}

