/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetradapp.gene.editor.WeightedDisplayEdgeInterface;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.PointPair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public final class LabeledGraphEdge
extends DisplayEdge
implements WeightedDisplayEdgeInterface {
    private String label;
    private boolean showLabel;
    private boolean showMulti;
    private double offset;
    private int alpha;
    private static final Stroke UNANCHORED_STROKE = new BasicStroke(1.0f);
    private static final Stroke NORMAL_STROKE = new BasicStroke(1.0f);
    private static final double CIRCULAR_RADIUS = 40.0;
    private static final int PADDING = 10;

    public LabeledGraphEdge(DisplayNode node1, DisplayNode node2, String label) {
        super(node1, node2, 0);
        this.setLabel(label);
        this.setAlpha(255);
        this.setShowMulti(false);
        this.resetBounds();
    }

    private void setLabel(String label) {
        this.label = label;
        this.setShowLabel(label != null);
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public int getWeight() {
        return Integer.parseInt(this.label);
    }

    @Override
    public void setWeight(int weight) {
        this.label = String.valueOf(weight);
    }

    public boolean getShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
        this.repaint();
    }

    public boolean getShowMulti() {
        return this.showMulti;
    }

    public void setShowMulti(boolean showMulti) {
        this.showMulti = showMulti;
        this.repaint();
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(double offset) {
        this.offset = offset;
        this.resetBounds();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    private void paintCircle(Graphics2D g) {
        Point c = new Point(40, 40);
        double rad_off = this.calcRadFromOffset(this.offset);
        double start = this.normalize(this.searchCircleBoundaryIntersection(true, c));
        double end = this.normalize(this.searchCircleBoundaryIntersection(false, c));
        int astart = (int)(start / Math.PI * 180.0);
        int da = (int)(this.normalize(end - start) / Math.PI * 180.0);
        int inner_dia = 60;
        if (this.showLabel) {
            int gap = 19;
            int da1 = (int)(this.normalize(rad_off - start) / Math.PI * 180.0);
            int da2 = (int)(this.normalize(end - rad_off) / Math.PI * 180.0);
            g.drawArc(10, 10, inner_dia, inner_dia, astart, da1 - gap);
            g.drawArc(10, 10, inner_dia, inner_dia, astart + da1 + gap, da2 - gap);
        } else {
            g.drawArc(10, 10, inner_dia, inner_dia, astart, da);
        }
        if (this.showMulti) {
            int w = Integer.parseInt(this.label);
            double dr = (double)da / (double)w / 180.0 * Math.PI;
            for (int i = 0; i < w; ++i) {
                Point intersect = this.calcCircularPointFromAngle(end - dr * (double)i, c);
                Point endpoint = this.calcCircularPointFromAngle(end - dr * (double)i - 0.4, c);
                this.drawArrowEndpoint(endpoint, intersect, g);
            }
        } else {
            Point intersect = this.calcCircularPointFromAngle(end, c);
            Point endpoint = this.calcCircularPointFromAngle(end - 0.4, c);
            this.drawArrowEndpoint(endpoint, intersect, g);
        }
        if (this.showLabel) {
            int width = g.getFontMetrics().stringWidth(this.label);
            Point labelloc = this.calcCircularPointFromAngle(rad_off, c);
            g.setColor(Color.black);
            g.drawString(this.label, labelloc.x - width / 2, labelloc.y + 5);
        }
    }

    private double normalize(double a) {
        while (a < 0.0) {
            a += Math.PI * 2;
        }
        while (a >= Math.PI * 2) {
            a -= Math.PI * 2;
        }
        return a;
    }

    private double calcRadFromOffset(double offset) {
        return offset / 40.0 * 2.0 * Math.PI * 2.0;
    }

    private Point calcCircleCenter() {
        Rectangle r = this.getNode1().getBounds();
        Point loc = new Point(r.x + r.width / 2, r.y + r.height / 2);
        int x = (int)(40.0 * Math.cos(this.calcRadFromOffset(this.offset)));
        int y = (int)(40.0 * Math.sin(this.calcRadFromOffset(this.offset)));
        return new Point(x + loc.x, -y + loc.y);
    }

    private Point calcCircularPointFromAngle(double a, Point center) {
        int x = (int)(30.0 * Math.cos(a));
        int y = (int)(30.0 * Math.sin(a));
        return new Point(x + center.x, -y + center.y);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.getNode1() == this.getNode2()) {
            if (x < 0 || y < 0 || x > this.getWidth() || y > this.getHeight()) {
                return false;
            }
            Point c = new Point(40, 40);
            int dx = (int)((double)x - 40.0);
            int dy = (int)(40.0 - (double)y);
            double dist = Math.sqrt(dx * dx + dy * dy);
            double a = this.normalize(Math.atan2(dy, dx));
            double start = this.normalize(this.searchCircleBoundaryIntersection(true, c));
            double end = this.normalize(this.searchCircleBoundaryIntersection(false, c));
            return (a > start || a < end) && dist > 25.0 && dist < 35.0;
        }
        return super.contains(x, y);
    }

    private double searchCircleBoundaryIntersection(boolean clockwise, Point c) {
        double from = this.calcRadFromOffset(this.offset) + Math.PI;
        double to = clockwise ? from + Math.PI : from - Math.PI;
        Point node1loc = this.getNode1().getLocation();
        Point node1offset = new Point(this.getLocation().x - node1loc.x, this.getLocation().y - node1loc.y);
        double mid = (from + to) / 2.0;
        while (Math.abs(from - to) * 40.0 > 2.0) {
            Point pMid = this.calcCircularPointFromAngle(mid, c);
            if (this.getNode1().contains(pMid.x + node1offset.x, pMid.y + node1offset.y)) {
                from = mid;
            } else {
                to = mid;
            }
            mid = (from + to) / 2.0;
        }
        return mid;
    }

    @Override
    protected void resetBounds() {
        if (this.getNode1() != this.getNode2()) {
            super.resetBounds();
        } else {
            Point c = this.calcCircleCenter();
            this.setBounds(c.x - 40, c.y - 40, 80, 80);
        }
    }

    @Override
    public void paint(Graphics g) {
        PointPair pp;
        Graphics2D g2 = (Graphics2D)g;
        Stroke origStroke = g2.getStroke();
        switch (this.getMode()) {
            case 0: {
                g.setColor(this.getLineColor());
                g2.setStroke(UNANCHORED_STROKE);
                break;
            }
            case 1: {
                g.setColor(this.getLineColor());
                g2.setStroke(NORMAL_STROKE);
                break;
            }
            case 2: {
                g.setColor(this.getSelectedColor());
                g2.setStroke(NORMAL_STROKE);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Color c = g.getColor();
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha));
        if (this.getNode1() == this.getNode2()) {
            this.paintCircle(g2);
            g2.setStroke(origStroke);
        }
        if ((pp = this.getMode() == 0 ? this.calculateEdge(this.getNode1(), this.getRelativeMouseTrackPoint()) : this.calculateEdge(this.getNode1(), this.getNode2())) != null) {
            pp.getFrom().translate(-this.getLocation().x, -this.getLocation().y);
            pp.getTo().translate(-this.getLocation().x, -this.getLocation().y);
            this.setClickRegion(null);
            double rad = 10.0;
            double cx = (pp.getFrom().x + pp.getTo().x) / 2;
            double cy = (pp.getFrom().y + pp.getTo().y) / 2;
            if (this.showLabel) {
                Point p2;
                Point p1;
                if (pp.getFrom().x == pp.getTo().x) {
                    if (pp.getFrom().y < pp.getTo().y) {
                        rad = -rad;
                    }
                    p1 = new Point((int)cx, (int)(cy + rad));
                    p2 = new Point((int)cx, (int)(cy - rad));
                } else {
                    if (pp.getFrom().x >= pp.getTo().x) {
                        rad = -rad;
                    }
                    double slope = (double)(pp.getFrom().y - pp.getTo().y) / (double)(pp.getFrom().x - pp.getTo().x);
                    double a = rad / Math.sqrt(slope * slope + 1.0);
                    double b = slope * a;
                    p1 = new Point((int)(cx - a), (int)(cy - b));
                    p2 = new Point((int)(cx + a), (int)(cy + b));
                }
                g.drawLine(pp.getFrom().x, pp.getFrom().y, p1.x, p1.y);
                g.drawLine(p2.x, p2.y, pp.getTo().x, pp.getTo().y);
            } else {
                g.drawLine(pp.getFrom().x, pp.getFrom().y, pp.getTo().x, pp.getTo().y);
            }
            g2.setStroke(origStroke);
            if (this.showMulti) {
                int w = Integer.parseInt(this.label);
                if (pp.getFrom().x == pp.getTo().x) {
                    double dy = (double)(pp.getFrom().y - pp.getTo().y) / (double)w;
                    for (int i = 1; i <= w; ++i) {
                        Point p = new Point(pp.getFrom().x, pp.getFrom().y - (int)(dy * (double)i));
                        this.drawArrowEndpoint(pp.getFrom(), p, g);
                    }
                } else {
                    double dx = (double)(pp.getFrom().x - pp.getTo().x) / (double)w;
                    double dy = (double)(pp.getFrom().y - pp.getTo().y) / (double)w;
                    for (int i = 1; i <= w; ++i) {
                        Point p = new Point(pp.getFrom().x - (int)(dx * (double)i), pp.getFrom().y - (int)(dy * (double)i));
                        this.drawArrowEndpoint(pp.getFrom(), p, g);
                    }
                }
            } else {
                this.drawEndpoints(pp, g);
            }
            if (this.showLabel) {
                int width = g.getFontMetrics().stringWidth(this.label);
                g.setColor(Color.black);
                g.drawString(this.label, (int)(cx - (double)(width / 2)), (int)(cy + Math.abs(rad) / 2.0));
            }
            this.setConnectedPoints(pp);
            this.firePropertyChange("newPointPair", null, pp);
        }
    }

    private void drawArrowEndpoint(Point from, Point to, Graphics g) {
        double a = to.x - from.x;
        double b = from.y - to.y;
        double theta = Math.atan2(b, a);
        int itheta = (int)(theta * 360.0 / (Math.PI * 2) + 180.0);
        g.fillArc(to.x - 18, to.y - 18, 36, 36, itheta - 15, 30);
    }

    @Override
    public void launchAssociatedEditor() {
        String old = this.label;
        this.label = JOptionPane.showInputDialog("Time lag of edge:");
        if (this.label == null || Integer.parseInt(this.label) <= 0) {
            this.label = old;
        } else {
            this.firePropertyChange("edgeLaunch", old, this);
        }
    }

    private PointPair calculateEdge(JComponent comp1, JComponent comp2) {
        Rectangle r1 = comp1.getBounds();
        Rectangle r2 = comp2.getBounds();
        Point c1 = new Point((int)((double)r1.x + (double)r1.width / 2.0), (int)((double)r1.y + (double)r1.height / 2.0));
        Point c2 = new Point((int)((double)r2.x + (double)r2.width / 2.0), (int)((double)r2.y + (double)r2.height / 2.0));
        double angle = Math.atan2(c1.y - c2.y, c1.x - c2.x);
        Point d = new Point((int)(this.offset * Math.cos(angle += 1.5707963267948966)), (int)(this.offset * Math.sin(angle)));
        c1.translate(d.x, d.y);
        c2.translate(d.x, d.y);
        Point p1 = this.getBoundaryIntersection(comp1, c1, c2);
        Point p2 = this.getBoundaryIntersection(comp2, c2, c1);
        if (p1 == null || p2 == null) {
            return null;
        }
        return new PointPair(p1, p2);
    }

    private Point getBoundaryIntersection(JComponent comp, Point pIn, Point pOut) {
        Point loc = comp.getLocation();
        if (!comp.contains(pIn.x - loc.x, pIn.y - loc.y)) {
            return null;
        }
        if (comp.contains(pOut.x - loc.x, pOut.y - loc.y)) {
            return null;
        }
        Point pFrom = new Point(pOut);
        Point pTo = new Point(pIn);
        Point pMid = null;
        while (LabeledGraphEdge.distance(pFrom, pTo) > 2.0) {
            pMid = new Point((pFrom.x + pTo.x) / 2, (pFrom.y + pTo.y) / 2);
            if (comp.contains(pMid.x - loc.x, pMid.y - loc.y)) {
                pTo = pMid;
                continue;
            }
            pFrom = pMid;
        }
        return pMid;
    }
}

