/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetradapp.gene.editor.LagGraphEditor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;

public class LagGraphTopToolbar
extends JPanel
implements PropertyChangeListener {
    protected ButtonGroup group;
    protected JToggleButton directView;
    protected JToggleButton repeatView;
    protected JToggleButton tableView;
    protected LagGraphEditor editor;
    JPanel repeatingOptionsPanel;
    JPanel directedOptionsPanel;
    JPanel tabularOptionsPanel;
    JPanel optionsPanel;

    public LagGraphTopToolbar(LagGraphEditor editor) {
        this.editor = editor;
        this.group = new ButtonGroup();
        this.setLayout(new BoxLayout(this, 0));
        MatteBorder insideBorder = new MatteBorder(10, 10, 10, 10, this.getBackground());
        EtchedBorder outsideBorder = new EtchedBorder();
        this.setBorder(new CompoundBorder(outsideBorder, insideBorder));
        this.repeatingOptionsPanel = new JPanel();
        this.repeatingOptionsPanel.setLayout(new BoxLayout(this.repeatingOptionsPanel, 1));
        this.directedOptionsPanel = new JPanel();
        this.directedOptionsPanel.setLayout(new BoxLayout(this.directedOptionsPanel, 1));
        this.tabularOptionsPanel = new JPanel();
        this.tabularOptionsPanel.setLayout(new BoxLayout(this.tabularOptionsPanel, 1));
        this.directView = new JToggleButton();
        this.repeatView = new JToggleButton();
        this.tableView = new JToggleButton();
        JRadioButton lagGraphButton = new JRadioButton("Lag Graph", false);
        JRadioButton hybridGraphButton = new JRadioButton("Hybrid Graph", true);
        JRadioButton repeatGraphButton = new JRadioButton("Repeating Graph", false);
        this.repeatingOptionsPanel.add(lagGraphButton);
        this.repeatingOptionsPanel.add(hybridGraphButton);
        this.repeatingOptionsPanel.add(repeatGraphButton);
        ButtonGroup bg = new ButtonGroup();
        bg.add(lagGraphButton);
        bg.add(hybridGraphButton);
        bg.add(repeatGraphButton);
        JCheckBox multiArrowGraphButton = new JCheckBox("Multple Arrowheads");
        JCheckBox numLabelGraphButton = new JCheckBox("Numerical Label");
        numLabelGraphButton.setSelected(true);
        this.directedOptionsPanel.add(new JLabel("Show Lags as:"));
        this.directedOptionsPanel.add(multiArrowGraphButton);
        this.directedOptionsPanel.add(numLabelGraphButton);
        this.directView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LagGraphTopToolbar.this.doSwitchDirected();
            }
        });
        this.repeatView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LagGraphTopToolbar.this.doSwitchRepeating();
            }
        });
        this.tableView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LagGraphTopToolbar.this.doSwitchTabular();
            }
        });
        lagGraphButton.addActionListener(editor);
        hybridGraphButton.addActionListener(editor);
        repeatGraphButton.addActionListener(editor);
        multiArrowGraphButton.addActionListener(editor);
        numLabelGraphButton.addActionListener(editor);
        this.addButton(this.directView, "direct");
        this.addButton(this.repeatView, "repeat");
        this.addButton(this.tableView, "table");
        this.selectViews();
    }

    public void doSwitchDirected() {
        if (this.optionsPanel != null) {
            this.remove(this.optionsPanel);
        }
        this.optionsPanel = this.directedOptionsPanel;
        this.add(this.optionsPanel);
        this.directView.setSelected(true);
        this.editor.switchDirected();
    }

    public void doSwitchRepeating() {
        if (this.optionsPanel != null) {
            this.remove(this.optionsPanel);
        }
        this.optionsPanel = this.repeatingOptionsPanel;
        this.add(this.optionsPanel);
        this.repeatView.setSelected(true);
        this.editor.switchRepeating();
    }

    public void doSwitchTabular() {
        if (this.optionsPanel != null) {
            this.remove(this.optionsPanel);
        }
        this.optionsPanel = this.tabularOptionsPanel;
        this.add(this.optionsPanel);
        this.tableView.setSelected(true);
        this.editor.switchTabular();
    }

    private void addButton(JToggleButton jb, String name) {
        jb.setIcon(new ImageIcon(this.getImage(name + "Up.gif")));
        jb.setRolloverIcon(new ImageIcon(this.getImage(name + "Roll.gif")));
        jb.setPressedIcon(new ImageIcon(this.getImage(name + "Down.gif")));
        jb.setSelectedIcon(new ImageIcon(this.getImage(name + "Down.gif")));
        jb.setDisabledIcon(new ImageIcon(this.getImage(name + "Off.gif")));
        jb.setRolloverEnabled(true);
        jb.setBorder(new EmptyBorder(1, 1, 1, 1));
        jb.setSize(100, 50);
        jb.setMinimumSize(new Dimension(100, 50));
        jb.setPreferredSize(new Dimension(100, 50));
        this.add(jb);
        this.group.add(jb);
    }

    private Image getImage(String path) {
        try {
            String fullPath = "/resources/images/" + path;
            URL url = this.getClass().getResource(fullPath);
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("graph".equals(e.getPropertyName())) {
            this.selectViews();
        }
    }

    private void selectViews() {
        this.directView.setEnabled(true);
        this.repeatView.setEnabled(true);
        this.tableView.setEnabled(true);
    }
}

