/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetrad.gene.graph.ActiveLagGraph;
import edu.cmu.tetrad.gene.history.LaggedEdge;
import edu.cmu.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.gene.editor.LagGraphWorkbench;
import edu.cmu.tetradapp.gene.editor.MultiGraphEdge;
import edu.cmu.tetradapp.gene.editor.MultiGraphNode;
import edu.cmu.tetradapp.gene.editor.TimesteppedFactor;
import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.IDisplayEdge;
import edu.cmu.tetradapp.workbench.Rubberband;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;

public class MultiGraphWorkbench
extends JComponent
implements LagGraphWorkbench,
Scrollable {
    public static final int SELECT_MOVE = 0;
    public static final int ADD_NODE = 1;
    public static final int ADD_EDGE = 2;
    public static final String BASE_FACTOR_NAME = "Gene";
    public static final int EDGE_LAG = 0;
    public static final int EDGE_HYBRID = 1;
    public static final int EDGE_REPEATING = 2;
    public static final int TIME_DEST = 0;
    public static final int TIME_SRC = 1;
    public static final int MAX_TIMELAG = 10;
    protected ActiveLagGraph modelGraph;
    protected Map displayFactors;
    private int workbenchMode = 0;
    private final Color BACKGROUND = Color.white;
    private DisplayEdge trackedEdge;
    private Point clickPoint;
    private Rubberband rubberband;
    private boolean allowRubberband = true;
    private boolean allowUserEditing = true;
    private boolean allowMultipleNodeSelection = true;
    private ComponentHandler compHandler = new ComponentHandler();
    private MouseHandler mouseHandler = new MouseHandler();
    private PropertyChangeHandler propChangeHandler = new PropertyChangeHandler();
    private JPopupMenu nodePopup;
    private JPopupMenu edgePopup;
    private int next_factor_cursor = 0;
    private int past_steps_shown;
    private int future_steps_shown;
    private int hgap = 120;
    private int vgap = 100;
    private JPanel curTimeGroup;
    private JPanel pastPanel;
    private JPanel curPanel;
    private JPanel futurePanel;
    private JPanel[] curTimePanels;
    public static final int MEASURED_NODE = 0;
    public static final int DIRECTED_EDGE = 0;
    private int edgeMode = 0;
    private int edgeDisplayMode = 1;
    private int timeMode = 0;
    private static final String POPUP_DELETE = "Delete selection";
    private static final String POPUP_RENAME = "Rename factor";

    public MultiGraphWorkbench(ActiveLagGraph lagGraph) {
        this.initComponents();
        this.displayFactors = new HashMap();
        this.setModelGraph(lagGraph);
        Dimension group_size = this.curTimeGroup.getPreferredSize();
        this.curTimeGroup.setBounds(10, this.vgap * 10 - 10, group_size.width, group_size.height);
        this.repaint();
        this.revalidate();
        this.adjustPreferredSize();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.setCursor(null);
    }

    private void initComponents() {
        PopupListener popupListener = new PopupListener();
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        this.nodePopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(POPUP_RENAME);
        menuItem.addActionListener(popupListener);
        this.nodePopup.add(menuItem);
        menuItem = new JMenuItem(POPUP_DELETE);
        menuItem.addActionListener(popupListener);
        menuItem.setAccelerator(delete);
        this.nodePopup.add(menuItem);
        this.edgePopup = new JPopupMenu();
        menuItem = new JMenuItem(POPUP_DELETE);
        menuItem.addActionListener(popupListener);
        menuItem.setAccelerator(delete);
        this.edgePopup.add(menuItem);
        Color transparentWhite = new Color(255, 255, 255, 0);
        JLabel pastLabel = new JLabel("Past time", new ImageIcon(ImageUtils.getImage(this, "arrow-up.gif")), 0);
        JLabel futureLabel = new JLabel("Future time", new ImageIcon(ImageUtils.getImage(this, "arrow-down.gif")), 0);
        JLabel curLabel = new JLabel("Current Time", new ImageIcon(ImageUtils.getImage(this, "arrow-left.gif")), 0);
        this.pastPanel = new JPanel();
        this.pastPanel.setBackground(transparentWhite);
        this.pastPanel.setLayout(new BoxLayout(this.pastPanel, 0));
        this.futurePanel = new JPanel();
        this.futurePanel.setBackground(transparentWhite);
        this.futurePanel.setLayout(new BoxLayout(this.futurePanel, 0));
        this.curPanel = new JPanel();
        this.curPanel.setBackground(transparentWhite);
        this.curPanel.setBorder(BorderFactory.createLineBorder(curLabel.getForeground()));
        this.curPanel.setLayout(new BoxLayout(this.curPanel, 0));
        this.curTimeGroup = new JPanel();
        this.curTimeGroup.setLayout(new BorderLayout());
        this.curTimeGroup.setBackground(transparentWhite);
        Dimension labelSize = curLabel.getPreferredSize();
        int boxWidth = this.hgap * this.next_factor_cursor + labelSize.width + 20;
        this.pastPanel.add(Box.createRigidArea(new Dimension(boxWidth - labelSize.width, labelSize.height + 10)));
        this.curPanel.add(Box.createRigidArea(new Dimension(boxWidth - labelSize.width, this.vgap)));
        this.futurePanel.add(Box.createRigidArea(new Dimension(boxWidth - labelSize.width, labelSize.height + 10)));
        JPanel[] temp = new JPanel[]{this.pastPanel, this.curPanel, this.futurePanel};
        this.curTimePanels = temp;
        this.pastPanel.add(pastLabel);
        this.curPanel.add(curLabel);
        this.curPanel.add(Box.createRigidArea(new Dimension(10, this.vgap)));
        this.futurePanel.add(futureLabel);
        this.curTimeGroup.add((Component)this.pastPanel, "North");
        this.curTimeGroup.add((Component)this.curPanel, "Center");
        this.curTimeGroup.add((Component)this.futurePanel, "South");
        this.add(this.curTimeGroup);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public int getVGap() {
        return this.vgap;
    }

    public int getPastSteps() {
        return this.past_steps_shown;
    }

    public int getFutureSteps() {
        return this.future_steps_shown;
    }

    public void setPastSteps(int past_steps) {
        if (past_steps != this.past_steps_shown) {
            this.past_steps_shown = past_steps;
            Iterator it = this.displayFactors.values().iterator();
            while (it.hasNext()) {
                ((TimesteppedFactor)it.next()).setPastSteps(this.getPastSteps());
            }
        }
    }

    public void setFutureSteps(int future_steps) {
        if (future_steps != this.future_steps_shown) {
            this.future_steps_shown = future_steps;
            Iterator it = this.displayFactors.values().iterator();
            while (it.hasNext()) {
                ((TimesteppedFactor)it.next()).setFutureSteps(this.getFutureSteps());
            }
        }
    }

    public int getEdgeDisplayMode() {
        return this.edgeDisplayMode;
    }

    public void setEdgeDisplayMode(int edgeMode) {
        if (edgeMode != this.edgeDisplayMode) {
            switch (edgeMode) {
                case 0: 
                case 1: 
                case 2: {
                    this.edgeDisplayMode = edgeMode;
                    for (String key : this.displayFactors.keySet()) {
                        this.getDisplayFactor(key).setEdgeMode(this.getEdgeDisplayMode());
                    }
                    this.firePropertyChange("edgeDisplayMode", null, (Object)this.getEdgeDisplayMode());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal edge mode");
                }
            }
        }
    }

    public int getTimeMode() {
        return this.timeMode;
    }

    public void setTimeMode(int timeMode) {
        if (timeMode != this.timeMode) {
            switch (timeMode) {
                case 0: 
                case 1: {
                    this.timeMode = timeMode;
                    for (String key : this.displayFactors.keySet()) {
                        this.getDisplayFactor(key).setTimeMode(this.getTimeMode());
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal time mode");
                }
            }
        }
    }

    @Override
    public ActiveLagGraph getModelGraph() {
        return this.modelGraph;
    }

    @Override
    public void setModelGraph(ActiveLagGraph modelGraph) {
        if (this.getModelGraph() != null) {
            this.getModelGraph().removePropertyChangeListener(this.propChangeHandler);
        }
        this.modelGraph = modelGraph;
        this.unregisterKeys();
        if (modelGraph != null) {
            SortedSet<String> factors = this.getModelGraph().getFactors();
            int maxLag = this.getModelGraph().getMaxLagAllowable();
            this.setPastSteps(10 + maxLag);
            this.setFutureSteps(10 + maxLag);
            while (this.displayFactors.size() > 0) {
                String f = (String)this.displayFactors.keySet().iterator().next();
                this.next_factor_cursor = 0;
                this.removeNode(f);
            }
            Iterator it = factors.iterator();
            while (it.hasNext()) {
                this.addNode((String)it.next());
            }
            for (String factor : factors) {
                this.getDisplayFactor(factor).synchDisplayEdges();
            }
            this.adjustPreferredSize();
            this.getModelGraph().addPropertyChangeListener(this.propChangeHandler);
            this.registerKeys();
        }
    }

    public void scrollToHome() {
        Iterator it = this.displayFactors.keySet().iterator();
        if (it.hasNext()) {
            String itm = (String)it.next();
            Rectangle init = null;
            for (int timestep = -1; timestep <= 1; ++timestep) {
                if (this.getDisplayFactor(itm).getPastSteps() < timestep && this.getDisplayFactor(itm).getFutureSteps() < timestep) continue;
                if (init == null) {
                    init = this.getDisplayFactor(itm).getDisplayNode(timestep).getBounds();
                }
                while (it.hasNext()) {
                    itm = (String)it.next();
                    init = init.union(this.getDisplayFactor(itm).getDisplayNode(timestep).getBounds());
                }
            }
            init.translate(0, -this.vgap / 2);
            init.setSize((int)init.getWidth(), (int)init.getHeight() + this.vgap);
            this.scrollRectToVisible(init);
        } else {
            this.scrollRectToVisible(this.getVisibleRect());
        }
    }

    public TimesteppedFactor getDisplayFactor(String name) {
        return (TimesteppedFactor)this.displayFactors.get(name);
    }

    public void newNode() {
        String name = this.nextVariableName(BASE_FACTOR_NAME);
        this.getModelGraph().addFactor(name);
        LaggedFactor toSelf = new LaggedFactor(name, 1);
        this.getModelGraph().addEdge(name, toSelf);
    }

    protected TimesteppedFactor addNode(String name) {
        for (int i = 0; i < this.curTimePanels.length; ++i) {
            this.curTimePanels[i].add(Box.createRigidArea(new Dimension(this.hgap, 1)), 0);
        }
        int nodeX = -(this.hgap / 2) + this.hgap * ++this.next_factor_cursor;
        int nodeY = 70 + this.vgap * 10;
        TimesteppedFactor displayNode = new TimesteppedFactor(name, this, nodeX, nodeY);
        this.displayFactors.put(name, displayNode);
        displayNode.setPastSteps(this.getPastSteps());
        displayNode.setFutureSteps(this.getFutureSteps());
        displayNode.setTimeMode(this.getTimeMode());
        displayNode.setEdgeMode(this.getEdgeDisplayMode());
        return displayNode;
    }

    public void removeNode(String name) {
        TimesteppedFactor factor = (TimesteppedFactor)this.displayFactors.remove(name);
        factor.removeDisplayNodes();
        this.displayFactors.remove(name);
        this.adjustPreferredSize();
    }

    public void bindNode(DisplayNode displayNode) {
        DisplayNode displayNodeComp = displayNode;
        this.add((Component)displayNodeComp, 0);
        displayNodeComp.addComponentListener(this.compHandler);
        displayNodeComp.addMouseListener(this.mouseHandler);
        displayNodeComp.addMouseMotionListener(this.mouseHandler);
        displayNodeComp.setSize(((Component)displayNodeComp).getPreferredSize());
        this.adjustPreferredSize();
    }

    public void bindEdge(DisplayEdge displayEdge) {
        this.add((Component)displayEdge, -1);
        displayEdge.addComponentListener(this.compHandler);
        displayEdge.addMouseListener(this.mouseHandler);
        displayEdge.addMouseMotionListener(this.mouseHandler);
        displayEdge.addPropertyChangeListener(this.propChangeHandler);
    }

    public DisplayEdge getNewTrackingEdge(DisplayNode node, Point mouseLoc) {
        DisplayEdge trackedEdge = null;
        switch (this.edgeMode) {
            case 0: {
                trackedEdge = new DisplayEdge(node, mouseLoc, 0);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return trackedEdge;
    }

    private void startEdge(DisplayNode node, Point mouseLoc) {
        if (this.trackedEdge != null) {
            this.remove(this.trackedEdge);
            this.trackedEdge = null;
            this.repaint();
        }
        this.trackedEdge = this.getNewTrackingEdge(node, mouseLoc);
        this.add((Component)this.trackedEdge, -1);
        this.deselectAll();
    }

    private void finishEdge() {
        if (this.trackedEdge == null) {
            return;
        }
        DisplayNode comp1 = this.trackedEdge.getComp1();
        Point p = this.trackedEdge.getTrackPoint();
        DisplayNode comp2 = this.findNearestNode(p);
        MultiGraphNode node1 = (MultiGraphNode)comp1;
        MultiGraphNode node2 = (MultiGraphNode)comp2;
        int lag = node2.getTimestep() - node1.getTimestep();
        this.remove(this.trackedEdge);
        this.trackedEdge = null;
        LaggedFactor lf = new LaggedFactor(node1.getFactorGroup().getName(), lag);
        try {
            this.getModelGraph().addEdge(node2.getFactorGroup().getName(), lf);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.repaint();
    }

    protected void adjustTimestepsShown() {
        int maxlag = this.getModelGraph().getMaxLagAllowable();
        if (this.getPastSteps() < maxlag) {
            this.setPastSteps(maxlag);
        }
        if (this.getFutureSteps() < maxlag) {
            this.setFutureSteps(maxlag);
        }
    }

    public String nextVariableName(String base) {
        int i = 0;
        String name = null;
        while (this.modelGraph.existsFactor(name = base + ++i)) {
        }
        return name;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Component[] components = this.getComponents();
        Rectangle rw = this.curTimeGroup.getBounds();
        Rectangle rh = this.curTimeGroup.getBounds();
        int timeMode = this.getTimeMode();
        int maxLag = this.getModelGraph().getMaxLagAllowable();
        for (int i = 0; i < components.length; ++i) {
            MultiGraphNode n;
            if (components[i] instanceof MultiGraphNode && (Math.abs((n = (MultiGraphNode)components[i]).getTimestep()) <= 1 || Math.abs(n.getTimestep()) <= maxLag && (timeMode == 0 && n.getTimestep() < 0 || timeMode == 1 && n.getTimestep() > 0))) {
                rh = rh.union(n.getBounds());
            }
            rw = rw.union(components[i].getBounds());
        }
        rh.setSize(rh.width, rh.height + this.vgap);
        return new Dimension(rw.width, rh.height);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.vgap * 3;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.vgap;
    }

    private void adjustPreferredSize() {
        Component[] components = this.getComponents();
        Rectangle r = new Rectangle(0, 0, 330, 2 * this.vgap * 10);
        for (int i = 0; i < components.length; ++i) {
            r = r.union(components[i].getBounds());
        }
        r.setSize(r.width + 20, this.vgap * 21);
        this.setPreferredSize(new Dimension(r.width, r.height));
    }

    protected void promptDeleteSelectedObjects() {
        JLabel message = new JLabel("Really deleted selected objects?");
        int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), message, "Confirm Deletion", 2);
        if (ret == 0) {
            this.deleteSelectedObjects();
        }
    }

    protected void deleteSelectedObjects() {
        Component[] components = this.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            Component comp = components[i];
            if (comp instanceof IDisplayEdge) {
                if (!((IDisplayEdge)((Object)comp)).isSelected()) continue;
                MultiGraphNode node1 = (MultiGraphNode)((DisplayEdge)comp).getComp1();
                MultiGraphNode node2 = (MultiGraphNode)((DisplayEdge)comp).getComp2();
                int lag = node2.getTimestep() - node1.getTimestep();
                this.getModelGraph().removeEdge(node2.getName(), new LaggedFactor(node1.getName(), lag));
                continue;
            }
            if (!(comp instanceof DisplayNode) || !((DisplayNode)comp).isSelected()) continue;
            this.getModelGraph().removeFactor(comp.getName());
        }
        this.repaint();
    }

    protected void deselectAll() {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (comp instanceof IDisplayEdge) {
                ((IDisplayEdge)((Object)comp)).setSelected(false);
                continue;
            }
            if (!(comp instanceof DisplayNode)) continue;
            ((DisplayNode)comp).setSelected(false);
        }
        this.repaint();
    }

    protected double distance(Point p1, Point p2) {
        double d = 0.0;
        d = (p1.x - p2.x) * (p1.x - p2.x);
        d += (double)((p1.y - p2.y) * (p1.y - p2.y));
        d = Math.sqrt(d);
        return d;
    }

    protected DisplayNode findNearestNode(Point p) {
        Component[] components = this.getComponents();
        double leastDistance = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < components.length; ++i) {
            DisplayNode node;
            double distance;
            if (!(components[i] instanceof DisplayNode) || !((distance = this.distance(p, (node = (DisplayNode)components[i]).getCenterPoint())) < leastDistance)) continue;
            leastDistance = distance;
            index = i;
        }
        if (index != -1) {
            return (DisplayNode)components[index];
        }
        return null;
    }

    private void finishRubberband() {
        if (this.rubberband != null) {
            this.remove(this.rubberband);
            this.rubberband = null;
            this.repaint();
        }
    }

    public int getWorkbenchState() {
        return this.workbenchMode;
    }

    public int getWorkbenchMode() {
        return this.workbenchMode;
    }

    public List getSelectedNodes() {
        LinkedList<Component> selectedNodes = new LinkedList<Component>();
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (!(comp instanceof DisplayNode) || !((DisplayNode)comp).isSelected()) continue;
            selectedNodes.add(comp);
        }
        return selectedNodes;
    }

    public boolean getAllowUserEditing() {
        return this.allowUserEditing;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.BACKGROUND);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
    }

    protected void registerKeys() {
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiGraphWorkbench.this.promptDeleteSelectedObjects();
            }
        };
        KeyStroke backspace = KeyStroke.getKeyStroke(8, 0);
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        this.getInputMap(2).put(backspace, "DELETE");
        this.getInputMap(2).put(delete, "DELETE");
        this.getActionMap().put("DELETE", deleteAction);
    }

    protected void unbindNode(DisplayNode displayNode) {
        if (displayNode == null) {
            return;
        }
        this.remove(displayNode);
        this.repaint();
    }

    protected void unbindEdge(DisplayEdge displayEdge) {
        try {
            this.remove(displayEdge);
            this.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void selectAllInRubberband(Rubberband rubberband) {
        Shape rubberShape = rubberband.getShape();
        Point rubberLoc = rubberband.getLocation();
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            Rectangle bounds = comp.getBounds();
            bounds.translate(-rubberLoc.x, -rubberLoc.y);
            if (rubberShape.intersects(bounds)) {
                if (!(comp instanceof DisplayNode)) continue;
                ((DisplayNode)comp).setSelected(true);
                continue;
            }
            if (comp instanceof IDisplayEdge) {
                ((IDisplayEdge)((Object)comp)).setSelected(false);
                continue;
            }
            if (!(comp instanceof DisplayNode)) continue;
            ((DisplayNode)comp).setSelected(false);
        }
    }

    public void setWorkbenchMode(int workbenchMode) {
        switch (workbenchMode) {
            case 0: 
            case 1: 
            case 2: {
                if (this.workbenchMode == workbenchMode) break;
                this.workbenchMode = workbenchMode;
                this.deselectAll();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void setAllowUserEditing(boolean allowUserEditing) {
        if (this.allowUserEditing && !allowUserEditing) {
            this.unregisterKeys();
            this.allowUserEditing = false;
        } else if (!this.allowUserEditing && allowUserEditing) {
            this.registerKeys();
            this.allowUserEditing = true;
        }
    }

    private void startNodeDrag(Point p) {
        this.clickPoint = p;
    }

    private void startRubberband(Point p) {
        if (this.rubberband != null) {
            this.remove(this.rubberband);
            this.rubberband = null;
            this.repaint();
        }
        if (this.allowRubberband) {
            this.rubberband = new Rubberband(p);
            this.add((Component)this.rubberband, 0);
            this.rubberband.repaint();
        }
    }

    protected void unregisterKeys() {
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(8, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(127, 0));
    }

    class PopupListener
    implements ActionListener {
        PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu parent;
            JMenuItem source = (JMenuItem)e.getSource();
            if (source.getText().equals(MultiGraphWorkbench.POPUP_DELETE)) {
                MultiGraphWorkbench.this.promptDeleteSelectedObjects();
            } else if (source.getText().equals(MultiGraphWorkbench.POPUP_RENAME) && (parent = (JPopupMenu)source.getParent()) == MultiGraphWorkbench.this.nodePopup) {
                ((DisplayNode)parent.getInvoker()).doDoubleClickAction();
            }
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            Object old = e.getOldValue();
            Object _new = e.getNewValue();
            if (propName.equals("nodeAdded")) {
                TimesteppedFactor newNode = MultiGraphWorkbench.this.addNode((String)_new);
                newNode.synchDisplayEdges();
                Dimension group_size = MultiGraphWorkbench.this.curTimeGroup.getPreferredSize();
                MultiGraphWorkbench.this.curTimeGroup.setBounds(10, MultiGraphWorkbench.this.vgap * 10 - 10, group_size.width, group_size.height);
                MultiGraphWorkbench.this.repaint();
                MultiGraphWorkbench.this.revalidate();
                MultiGraphWorkbench.this.adjustPreferredSize();
            } else if (propName.equals("nodeRemoved")) {
                MultiGraphWorkbench.this.removeNode((String)old);
            } else if (propName.equals("edgeAdded")) {
                LaggedEdge le = (LaggedEdge)_new;
                MultiGraphWorkbench.this.getDisplayFactor(le.getFactor()).synchDisplayEdges();
                MultiGraphWorkbench.this.adjustTimestepsShown();
            } else if (propName.equals("edgeRemoved")) {
                LaggedEdge le = (LaggedEdge)old;
                MultiGraphWorkbench.this.getDisplayFactor(le.getFactor()).synchDisplayEdges();
            } else if (propName.equals("edgeLaunch")) {
                System.out.println("Attempt to launch edge.");
            } else if (propName.equals("maxLagAllowable")) {
                int maxLag = MultiGraphWorkbench.this.getModelGraph().getMaxLagAllowable();
                MultiGraphWorkbench.this.setPastSteps(10 + maxLag);
                MultiGraphWorkbench.this.setFutureSteps(10 + maxLag);
            } else if (propName.equals("factorRenamed")) {
                MultiGraphWorkbench.this.getDisplayFactor((String)old).setName((String)_new);
                MultiGraphWorkbench.this.displayFactors.put(_new, MultiGraphWorkbench.this.displayFactors.remove(old));
                MultiGraphWorkbench.this.repaint();
            }
        }
    }

    protected class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object source = e.getSource();
            switch (MultiGraphWorkbench.this.workbenchMode) {
                case 0: 
                case 1: 
                case 2: {
                    if (source instanceof DisplayNode) {
                        DisplayNode node = (DisplayNode)source;
                        if (e.getClickCount() == 2) {
                            MultiGraphWorkbench.this.deselectAll();
                            node.doDoubleClickAction();
                            break;
                        }
                        if (!e.isShiftDown() || !MultiGraphWorkbench.this.allowMultipleNodeSelection) {
                            MultiGraphWorkbench.this.deselectAll();
                        }
                        node.setSelected(true);
                        break;
                    }
                    if (source instanceof IDisplayEdge) {
                        IDisplayEdge edge = (IDisplayEdge)source;
                        if (e.getClickCount() == 2) {
                            MultiGraphWorkbench.this.deselectAll();
                            break;
                        }
                        if (edge.isSelected()) {
                            edge.setSelected(false);
                            break;
                        }
                        if (!e.isShiftDown() || !MultiGraphWorkbench.this.allowMultipleNodeSelection) {
                            MultiGraphWorkbench.this.deselectAll();
                        }
                        edge.setSelected(true);
                        break;
                    }
                    MultiGraphWorkbench.this.deselectAll();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Object source = e.getSource();
            if (!MultiGraphWorkbench.this.allowUserEditing) {
                return;
            }
            if (!this.maybeShowPopup(e)) {
                Point loc = e.getPoint();
                switch (MultiGraphWorkbench.this.workbenchMode) {
                    case 0: {
                        if (source == MultiGraphWorkbench.this) {
                            MultiGraphWorkbench.this.startRubberband(loc);
                            break;
                        }
                        if (!(source instanceof DisplayNode)) break;
                        MultiGraphWorkbench.this.startNodeDrag(loc);
                        break;
                    }
                    case 1: {
                        if (source != MultiGraphWorkbench.this) break;
                        MultiGraphWorkbench.this.newNode();
                        break;
                    }
                    case 2: {
                        DisplayNode nearestNode;
                        if (source instanceof DisplayNode) {
                            Point o = ((Component)source).getLocation();
                            loc.translate(o.x, o.y);
                        }
                        if ((nearestNode = MultiGraphWorkbench.this.findNearestNode(loc)) == null) break;
                        MultiGraphWorkbench.this.startEdge(nearestNode, loc);
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Object source = e.getSource();
            if (!MultiGraphWorkbench.this.allowUserEditing) {
                return;
            }
            if (!this.maybeShowPopup(e)) {
                switch (MultiGraphWorkbench.this.workbenchMode) {
                    case 0: {
                        if (source != MultiGraphWorkbench.this) break;
                        MultiGraphWorkbench.this.finishRubberband();
                        break;
                    }
                    case 2: {
                        MultiGraphWorkbench.this.finishEdge();
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!MultiGraphWorkbench.this.allowUserEditing) {
                return;
            }
            Object source = e.getSource();
            Point newPoint = e.getPoint();
            switch (MultiGraphWorkbench.this.workbenchMode) {
                case 0: {
                    if (source instanceof DisplayNode && MultiGraphWorkbench.this.clickPoint != null) {
                        DisplayNode node = (DisplayNode)source;
                        Point point = new Point(node.getLocation());
                        point.x += newPoint.x - ((MultiGraphWorkbench)MultiGraphWorkbench.this).clickPoint.x;
                        point.y += newPoint.y - ((MultiGraphWorkbench)MultiGraphWorkbench.this).clickPoint.y;
                        if (point.x < 0) {
                            point.x = 0;
                        }
                        if (point.y < 0) {
                            point.y = 0;
                        }
                        node.setLocation(point);
                        break;
                    }
                    if (MultiGraphWorkbench.this.rubberband == null) break;
                    MultiGraphWorkbench.this.rubberband.updateTrackPoint(newPoint);
                    MultiGraphWorkbench.this.selectAllInRubberband(MultiGraphWorkbench.this.rubberband);
                    break;
                }
                case 2: {
                    if (source instanceof DisplayNode) {
                        Point o = ((Component)source).getLocation();
                        newPoint.translate(o.x, o.y);
                    }
                    if (MultiGraphWorkbench.this.trackedEdge == null) break;
                    Rectangle bounds = MultiGraphWorkbench.this.trackedEdge.getBounds();
                    Rectangle visible = MultiGraphWorkbench.this.getVisibleRect();
                    if (!visible.contains(bounds)) {
                        MultiGraphWorkbench.this.scrollRectToVisible(bounds);
                    }
                    MultiGraphWorkbench.this.trackedEdge.updateTrackPoint(newPoint);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private boolean maybeShowPopup(MouseEvent e) {
            Object source = e.getSource();
            if (e.isPopupTrigger()) {
                if (source instanceof DisplayNode) {
                    if (!((DisplayNode)source).isSelected()) {
                        if (!e.isShiftDown() || !MultiGraphWorkbench.this.allowMultipleNodeSelection) {
                            MultiGraphWorkbench.this.deselectAll();
                        }
                        ((DisplayNode)source).setSelected(true);
                    }
                    MultiGraphWorkbench.this.nodePopup.show(e.getComponent(), e.getX(), e.getY());
                    return true;
                }
                if (source instanceof MultiGraphEdge) {
                    if (!((IDisplayEdge)source).isSelected()) {
                        if (!e.isShiftDown() || !MultiGraphWorkbench.this.allowMultipleNodeSelection) {
                            MultiGraphWorkbench.this.deselectAll();
                        }
                        ((IDisplayEdge)source).setSelected(true);
                    }
                    MultiGraphWorkbench.this.edgePopup.show(e.getComponent(), e.getX(), e.getY());
                    return true;
                }
            }
            return false;
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        protected ComponentHandler() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            Component source = (Component)e.getSource();
            Rectangle bounds = source.getBounds();
            Rectangle visible = MultiGraphWorkbench.this.getVisibleRect();
            if (!visible.contains(bounds)) {
                MultiGraphWorkbench.this.adjustPreferredSize();
                MultiGraphWorkbench.this.scrollRectToVisible(bounds);
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

