/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.gene.editor;

import edu.cmu.tetradapp.gene.editor.GraphTableWorkbench;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;

public class TableToolbar
extends JPanel {
    static final long serialVersionUID = 23L;
    private JToggleButton addObserved;
    private JToggleButton clearObserved;
    private GraphTableWorkbench workbench;

    public TableToolbar(GraphTableWorkbench workbench) {
        this.workbench = workbench;
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumSize(new Dimension(200, 10));
        MatteBorder insideBorder = new MatteBorder(10, 10, 10, 10, this.getBackground());
        EtchedBorder outsideBorder = new EtchedBorder();
        this.setBorder(new CompoundBorder(outsideBorder, insideBorder));
        this.addObserved = new JToggleButton();
        this.clearObserved = new JToggleButton();
        this.addObserved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableToolbar.this.createNewFactor();
                TableToolbar.this.addObserved.setSelected(false);
            }
        });
        this.clearObserved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableToolbar.this.clearFactors();
                TableToolbar.this.clearObserved.setSelected(false);
            }
        });
        this.addButton(this.addObserved, "variable");
        this.addButton(this.clearObserved, "clearVariable");
    }

    private void createNewFactor() {
        this.workbench.newFactor();
    }

    private void clearFactors() {
        this.workbench.clearFactors();
    }

    private void addButton(JToggleButton jb, String name) {
        jb.setIcon(new ImageIcon(this.getImage(name + "Up.gif")));
        jb.setRolloverIcon(new ImageIcon(this.getImage(name + "Roll.gif")));
        jb.setPressedIcon(new ImageIcon(this.getImage(name + "Down.gif")));
        jb.setSelectedIcon(new ImageIcon(this.getImage(name + "Down.gif")));
        jb.setDisabledIcon(new ImageIcon(this.getImage(name + "Off.gif")));
        jb.setRolloverEnabled(true);
        jb.setBorder(new EmptyBorder(1, 1, 1, 1));
        jb.setSize(100, 50);
        jb.setMinimumSize(new Dimension(100, 50));
        jb.setPreferredSize(new Dimension(100, 50));
        this.add(jb);
    }

    private Image getImage(String path) {
        try {
            String fullPath = "/resources/images/" + path;
            URL url = this.getClass().getResource(fullPath);
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

