/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestChiSquare;
import edu.cmu.tetrad.search.IndTestCramerT;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestFisherZBootstrap;
import edu.cmu.tetrad.search.IndTestFisherZGeneralizedInverse;
import edu.cmu.tetrad.search.IndTestGSquare;
import edu.cmu.tetrad.search.IndTestRegression;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.MarkovBlanketSearchRunner;
import edu.cmu.tetradapp.model.MbSearchParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMBSearchRunner
extends DataWrapper
implements MarkovBlanketSearchRunner {
    static final long serialVersionUID = 23L;
    private DataSet dataModel;
    private List<Node> variables;
    private DataSet source;
    private MbSearchParams params;
    private String searchName;

    public AbstractMBSearchRunner(DataModel source, MbSearchParams params) {
        super(AbstractMBSearchRunner.castData(source));
        if (source == null) {
            throw new NullPointerException("The source data was null.");
        }
        if (params == null) {
            throw new NullPointerException("Search params were null.");
        }
        this.params = params;
        this.source = (DataSet)source;
    }

    @Override
    public MbSearchParams getParams() {
        return this.params;
    }

    @Override
    public DataSet getDataModelForMarkovBlanket() {
        return this.dataModel;
    }

    @Override
    public List<Node> getMarkovBlanket() {
        return this.variables;
    }

    @Override
    public DataSet getSource() {
        return this.source;
    }

    @Override
    public void setSearchName(String n) {
        this.searchName = n;
    }

    @Override
    public String getSearchName() {
        if (this.searchName == null) {
            return "Markov Blanket Search";
        }
        return this.searchName;
    }

    protected void validate() {
        if (this.source.getNumColumns() == 0 || this.source.getNumRows() == 0) {
            throw new IllegalStateException("Cannot run algorithm on an empty data set.");
        }
    }

    protected void setSearchResults(List<Node> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes were null.");
        }
        this.variables = new ArrayList<Node>(nodes);
        this.dataModel = nodes.isEmpty() ? new ColtDataSet(this.source.getNumRows(), nodes) : this.source.subsetColumns(nodes);
        this.setDataModel(this.dataModel);
    }

    protected IndependenceTest getIndependenceTest() {
        IndTestType type = this.params.getIndTestType();
        if (this.source.isContinuous() || this.source.getNumColumns() == 0) {
            if (IndTestType.CORRELATION_T == type) {
                return new IndTestCramerT(this.source, this.params.getAlpha());
            }
            if (IndTestType.FISHER_Z == type) {
                return new IndTestFisherZ(this.source, this.params.getAlpha());
            }
            if (IndTestType.FISHER_ZD == type) {
                return new IndTestFisherZGeneralizedInverse(this.source, this.params.getAlpha());
            }
            if (IndTestType.FISHER_Z_BOOTSTRAP == type) {
                return new IndTestFisherZBootstrap(this.source, this.params.getAlpha(), 15, this.source.getNumRows() / 2);
            }
            if (IndTestType.LINEAR_REGRESSION == type) {
                return new IndTestRegression(this.source, this.params.getAlpha());
            }
            this.params.setIndTestType(IndTestType.CORRELATION_T);
            return new IndTestCramerT(this.source, this.params.getAlpha());
        }
        if (this.source.isDiscrete()) {
            if (IndTestType.G_SQUARE == type) {
                return new IndTestGSquare(this.source, this.params.getAlpha());
            }
            if (IndTestType.CHI_SQUARE == type) {
                return new IndTestChiSquare(this.source, this.params.getAlpha());
            }
            this.params.setIndTestType(IndTestType.CHI_SQUARE);
            return new IndTestChiSquare(this.source, this.params.getAlpha());
        }
        throw new IllegalStateException("Cannot find Independence for Data source.");
    }

    private static DataSet castData(DataModel model) {
        if (model instanceof DataSet) {
            return (DataSet)model;
        }
        throw new IllegalStateException("The data model must be a rectangular data set.");
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.params == null) {
            throw new NullPointerException();
        }
        if (this.source == null) {
            throw new NullPointerException();
        }
    }
}

