/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.session.ParamsResettable;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.MimParams;
import edu.cmu.tetradapp.model.MimRunner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public abstract class AbstractMimRunner
implements MimRunner,
ParamsResettable {
    static final long serialVersionUID = 23L;
    private String name;
    private DataModel dataModel;
    private MimParams params;
    private Clusters clusters = new Clusters();
    private Graph sourceGraph;
    private Graph resultGraph;
    private Graph structureGraph;

    public AbstractMimRunner(DataWrapper dataWrapper, Clusters clusters, MimParams params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
        this.setClusters(clusters);
        this.sourceGraph = dataWrapper.getSourceGraph();
        DataModel data = this.getDataModel(dataWrapper);
        this.getParams().setKnowledge(dataWrapper.getKnowledge());
        List<String> names = data.getVariableNames();
        this.transferVarNamesToParams(names);
        this.dataModel = data;
    }

    public AbstractMimRunner(MimRunner runner, MimParams params) {
        if (runner == null) {
            throw new NullPointerException();
        }
        System.out.println("JJ" + params.getClusters());
        this.params = params;
        this.params.setClusters(runner.getClusters());
        this.sourceGraph = runner.getSourceGraph();
        DataModel dataSource = runner.getData();
        List<String> names = dataSource.getVariableNames();
        this.transferVarNamesToParams(names);
        this.dataModel = dataSource;
    }

    @Override
    public final Graph getResultGraph() {
        return this.resultGraph;
    }

    @Override
    public Clusters getClusters() {
        return this.clusters;
    }

    @Override
    public Graph getStructureGraph() {
        return this.structureGraph;
    }

    @Override
    public final Graph getSourceGraph() {
        return this.sourceGraph;
    }

    @Override
    public final DataModel getData() {
        return this.dataModel;
    }

    @Override
    public final MimParams getParams() {
        return this.params;
    }

    @Override
    public void resetParams(Object params) {
        this.params = (MimParams)params;
    }

    @Override
    public Object getResettableParams() {
        return this.params;
    }

    protected void setResultGraph(Graph graph) {
        this.resultGraph = graph;
    }

    protected void setClusters(Clusters clusters) {
        if (clusters == null) {
            throw new NullPointerException();
        }
        System.out.println("AA: " + clusters);
        this.clusters = clusters;
        this.params.setClusters(clusters);
    }

    protected void setStructureGraph(Graph graph) {
        this.structureGraph = graph;
    }

    private DataModel getDataModel(DataWrapper dataWrapper) {
        DataModel dataModel = dataWrapper.getSelectedDataModel();
        if (dataModel instanceof DataModelList) {
            DataModelList dataModelList = (DataModelList)dataModel;
            dataModel = dataModelList.getSelectedModel();
        }
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            if (dataSet.isDiscrete()) {
                return dataSet;
            }
            if (dataSet.isContinuous()) {
                return dataSet;
            }
            throw new IllegalArgumentException("<html>This dataModel set contains a mixture of discrete and continuous <br>columns; there are no algorithms in Tetrad currently to <br>search over such data sets.</html>");
        }
        if (dataModel instanceof CovarianceMatrix) {
            return dataModel;
        }
        if (dataModel instanceof TimeSeriesData) {
            return dataModel;
        }
        throw new IllegalArgumentException("Unexpected dataModel source: " + dataModel);
    }

    private void transferVarNamesToParams(List names) {
        this.getParams().setVarNames(names);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dataModel == null) {
            throw new NullPointerException();
        }
        if (this.params == null) {
            throw new NullPointerException();
        }
        if (this.clusters == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

