/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BootstrapSampler;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.BootstrapSamplerParams;
import edu.cmu.tetradapp.model.DataWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BootstrapSamplerWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;
    private DataSet outputDataSet;

    public BootstrapSamplerWrapper(DataWrapper wrapper, BootstrapSamplerParams params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataModelList bootstraps = new DataModelList();
        DataModelList oldDataSets = wrapper.getDataModelList();
        for (DataModel dataModel : oldDataSets) {
            DataSet dataSet = (DataSet)dataModel;
            BootstrapSampler sampler = new BootstrapSampler();
            DataSet bootstrap = sampler.sample(dataSet, params.getSampleSize());
            bootstraps.add(bootstrap);
            if (oldDataSets.getSelectedModel() != dataModel) continue;
            bootstraps.setSelectedModel(bootstrap);
        }
        this.setDataModel(bootstraps);
        this.setSourceGraph(wrapper.getSourceGraph());
        DataModel dataModel = wrapper.getSelectedDataModel();
        DataSet dataSet = (DataSet)dataModel;
        BootstrapSampler sampler = new BootstrapSampler();
        this.outputDataSet = sampler.sample(dataSet, params.getSampleSize());
        LogObjectsUtils.logDataModelList("Bootstrap sample of data in the parent node.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new BootstrapSamplerWrapper(DataWrapper.serializableInstance(), BootstrapSamplerParams.serializableInstance());
    }

    public DataSet getOutputDataset() {
        return this.outputDataSet;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.outputDataSet == null) {
            throw new NullPointerException();
        }
    }
}

