/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.BuildPureClusters;
import edu.cmu.tetrad.search.MimUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.model.AbstractMimRunner;
import edu.cmu.tetradapp.model.BuildPureClustersParams;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BuildPureClustersRunner
extends AbstractMimRunner
implements GraphSource {
    static final long serialVersionUID = 23L;

    public BuildPureClustersRunner(DataWrapper dataWrapper, BuildPureClustersParams pureClustersParams) {
        super(dataWrapper, pureClustersParams.getClusters(), pureClustersParams);
    }

    public static BuildPureClustersRunner serializableInstance() {
        return new BuildPureClustersRunner(DataWrapper.serializableInstance(), BuildPureClustersParams.serializableInstance());
    }

    @Override
    public void execute() {
        DataModel source = this.getData();
        BuildPureClusters bpc = source instanceof CovarianceMatrix ? new BuildPureClusters((CovarianceMatrix)source, this.getParams().getAlpha(), this.getParams().getTetradTestType(), this.getParams().getPurifyTestType()) : (source instanceof DataSet ? new BuildPureClusters((DataSet)source, this.getParams().getAlpha(), this.getParams().getTetradTestType(), this.getParams().getPurifyTestType()) : new BuildPureClusters((DataSet)source, this.getParams().getAlpha(), this.getParams().getTetradTestType(), this.getParams().getPurifyTestType()));
        Graph searchGraph = bpc.search();
        System.out.println("HH " + searchGraph);
        if (searchGraph == null) {
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, JOptionUtils.centeringComp());
            final JDialog dialog = new JDialog(jFrame);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JLabel("No model found."), "Center");
            JButton button = new JButton("OK");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            panel.add((Component)button, "South");
            dialog.getContentPane().add((Component)panel, "Center");
            dialog.setLocationRelativeTo(JOptionUtils.centeringComp());
            dialog.pack();
            dialog.setVisible(true);
            this.setResultGraph(new EdgeListGraph());
            this.setClusters(new Clusters());
            return;
        }
        this.setResultGraph(searchGraph);
        GraphUtils.arrangeClustersInLine(this.getResultGraph(), true);
        this.setClusters(MimUtils.convertToClusters(searchGraph));
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }
}

