/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Cefs;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.BasicSearchParams;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.MbSearchParams;
import edu.cmu.tetradapp.model.MeekSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.util.LinkedList;
import java.util.List;

public class CeFanSearchRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;

    public CeFanSearchRunner(DataWrapper dataWrapper, MbSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
    }

    public CeFanSearchRunner(Graph graph, MbSearchParams params) {
        super(graph, params);
    }

    public CeFanSearchRunner(GraphWrapper graphWrapper, MbSearchParams params) {
        super(graphWrapper.getGraph(), params);
    }

    public CeFanSearchRunner(DagWrapper dagWrapper, MbSearchParams params) {
        super(dagWrapper.getDag(), params);
    }

    public CeFanSearchRunner(SemGraphWrapper dagWrapper, BasicSearchParams params) {
        super(dagWrapper.getGraph(), params);
    }

    public static CeFanSearchRunner serializableInstance() {
        return new CeFanSearchRunner((Graph)Dag.serializableInstance(), MbSearchParams.serializableInstance());
    }

    @Override
    public void execute() {
        int pcDepth = ((MbSearchParams)this.getParams()).getDepth();
        Cefs search = new Cefs(this.getIndependenceTest(), pcDepth);
        SearchParams params = this.getParams();
        if (params instanceof MeekSearchParams) {
            search.setAggressivelyPreventCycles(((MeekSearchParams)params).isAggressivelyPreventCycles());
        }
        String targetName = ((MbSearchParams)this.getParams()).getTargetName();
        Graph graph = search.search(targetName);
        this.setResultGraph(graph);
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (this.getParams().getKnowledge().isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, this.getParams().getKnowledge());
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        MbSearchParams params = (MbSearchParams)this.getParams();
        IndTestType testType = params.getIndTestType();
        return new IndTestFactory().getTest(dataModel, params, testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }
}

