/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Cfci;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.BasicSearchParams;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.FciSearchParamsOld;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestParams;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.util.ArrayList;
import java.util.List;

public class CfciRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;

    public CfciRunner(DataWrapper dataWrapper, FciSearchParamsOld params) {
        super(dataWrapper, (SearchParams)params, null);
    }

    public CfciRunner(GraphSource graphWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public CfciRunner(DataWrapper dataWrapper, FciSearchParamsOld params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public CfciRunner(Graph graph, FciSearchParamsOld params) {
        super(graph, params);
    }

    public CfciRunner(GraphWrapper graphWrapper, FciSearchParamsOld params) {
        super(graphWrapper.getGraph(), params);
    }

    public CfciRunner(DagWrapper dagWrapper, FciSearchParamsOld params) {
        super(dagWrapper.getDag(), params);
    }

    public CfciRunner(SemGraphWrapper dagWrapper, FciSearchParamsOld params) {
        super(dagWrapper.getGraph(), params);
    }

    public static CfciRunner serializableInstance() {
        return new CfciRunner((Graph)Dag.serializableInstance(), FciSearchParamsOld.serializableInstance());
    }

    @Override
    public void execute() {
        Knowledge knowledge = this.getParams().getKnowledge();
        SearchParams searchParams = this.getParams();
        IndTestParams indTestParams = searchParams.getIndTestParams();
        Cfci cfci = new Cfci(this.getIndependenceTest());
        cfci.setKnowledge(knowledge);
        cfci.setDepth(indTestParams.getDepth());
        Graph graph = cfci.search();
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        IndTestType testType;
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        SearchParams params = this.getParams();
        if (this.getParams() instanceof BasicSearchParams) {
            BasicSearchParams _params = (BasicSearchParams)params;
            testType = _params.getIndTestType();
        } else {
            FciSearchParamsOld _params = (FciSearchParamsOld)params;
            testType = _params.getIndTestType();
        }
        return new IndTestFactory().getTest(dataModel, params, testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Ambiguous Triples");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        triplesList.add(GraphUtils.getAmbiguousTriplesFromGraph(node, graph));
        return triplesList;
    }
}

