/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataWrapper
implements SessionModel,
KnowledgeEditable,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private DataModelList dataModelList;
    private Map discretizationSpecs = new HashMap();
    private Graph sourceGraph;
    private List<Node> knownVariables;
    private Params params = null;

    public DataWrapper() {
        this.setDataModel(new ColtDataSet(0, new LinkedList<Node>()));
    }

    public DataWrapper(DataWrapper wrapper) {
        this.name = wrapper.name;
        this.dataModelList = new DataModelList();
        int selected = -1;
        for (int i = 0; i < wrapper.dataModelList.size(); ++i) {
            if (!(wrapper.dataModelList.get(i) instanceof DataSet)) continue;
            DataSet data = (DataSet)wrapper.dataModelList.get(i);
            if (data.equals(wrapper.dataModelList.getSelectedModel())) {
                selected = i;
            }
            this.dataModelList.add(DataWrapper.copyData(data));
        }
        if (selected > -1) {
            this.dataModelList.setSelectedModel(this.dataModelList.get(selected));
        }
        if (wrapper.sourceGraph != null) {
            this.sourceGraph = new EdgeListGraph(wrapper.sourceGraph);
        }
        if (wrapper.knownVariables != null) {
            this.knownVariables = new ArrayList<Node>(wrapper.knownVariables);
        }
        LogObjectsUtils.logDataModelList("Standalone data set.", this.getDataModelList());
    }

    public DataWrapper(DataSet dataSet) {
        this.setDataModel(dataSet);
    }

    public DataWrapper(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        List<Node> nodes = graph.getNodes();
        LinkedList<Node> variables = new LinkedList<Node>();
        Iterator<Node> i$ = nodes.iterator();
        while (i$.hasNext()) {
            Node node1;
            Node node = node1 = i$.next();
            String name = node.getName();
            NodeType nodetype = node.getNodeType();
            if (nodetype != NodeType.MEASURED) continue;
            ContinuousVariable var = new ContinuousVariable(name);
            variables.add(var);
        }
        ColtDataSet dataSet = new ColtDataSet(0, variables);
        this.dataModelList = new DataModelList();
        this.dataModelList.add(dataSet);
    }

    public DataWrapper(DagWrapper dagWrapper) {
        this(dagWrapper.getDag());
    }

    public DataWrapper(SemGraphWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public DataWrapper(GraphWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public static DataWrapper serializableInstance() {
        return new DataWrapper(DataUtils.discreteSerializableInstance());
    }

    public DataModelList getDataModelList() {
        return this.dataModelList;
    }

    public void setDataModelList(DataModelList dataModelList) {
        this.dataModelList = dataModelList;
    }

    public DataModel getSelectedDataModel() {
        DataModelList modelList = this.dataModelList;
        return modelList.getSelectedModel();
    }

    public void setDataModel(DataModel dataModel) {
        if (dataModel == null) {
            dataModel = new ColtDataSet(0, new LinkedList<Node>());
        }
        if (dataModel instanceof DataModelList) {
            this.dataModelList = (DataModelList)dataModel;
        } else {
            this.dataModelList = new DataModelList();
            this.dataModelList.add(dataModel);
        }
    }

    @Override
    public Knowledge getKnowledge() {
        return this.getSelectedDataModel().getKnowledge();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.getSelectedDataModel().setKnowledge(knowledge);
    }

    @Override
    public List<String> getVarNames() {
        return this.getSelectedDataModel().getVariableNames();
    }

    @Override
    public Graph getSourceGraph() {
        return this.sourceGraph;
    }

    @Override
    public List<Node> getVariables() {
        return this.getSelectedDataModel().getVariables();
    }

    public void setSourceGraph(Graph sourceGraph) {
        this.sourceGraph = sourceGraph;
    }

    public void setKnownVariables(List<Node> variables) {
        this.knownVariables = variables;
    }

    public Map getDiscretizationSpecs() {
        return this.discretizationSpecs;
    }

    public List<Node> getKnownVariables() {
        return this.knownVariables;
    }

    private static DataModel copyData(DataSet data) {
        ColtDataSet newData = new ColtDataSet(data.getNumRows(), data.getVariables());
        for (int col = 0; col < data.getNumColumns(); ++col) {
            for (int row = 0; row < data.getNumRows(); ++row) {
                newData.setObject(row, col, data.getObject(row, col));
            }
        }
        newData.setKnowledge(new Knowledge(data.getKnowledge()));
        if (data.getName() != null) {
            newData.setName(data.getName());
        }
        return newData;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dataModelList == null) {
            throw new NullPointerException();
        }
        if (this.discretizationSpecs == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Params getParams() {
        return this.params;
    }

    public void setParams(Params params) {
        this.params = params;
    }

    @Override
    public List<String> getVariableNames() {
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node n : this.getVariables()) {
            variableNames.add(n.getName());
        }
        return variableNames;
    }
}

