/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.model.Params;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DirichletBayesImParams
implements Params {
    static final long serialVersionUID = 23L;
    public static final int MANUAL_RETAIN = 0;
    public static final int SYMMETRIC_PRIOR = 1;
    private int initializationMode = 1;
    private double symmetricAlpha = 1.0;

    public static DirichletBayesImParams serializableInstance() {
        return new DirichletBayesImParams();
    }

    public int getInitializationMode() {
        return this.initializationMode;
    }

    public void setInitializationMode(int initializationMode) {
        if (initializationMode != 0 && initializationMode != 1) {
            throw new IllegalArgumentException("Unrecognized initialization mode.");
        }
        this.initializationMode = initializationMode;
    }

    public double getSymmetricAlpha() {
        return this.symmetricAlpha;
    }

    public void setSymmetricAlpha(double symmetricAlpha) {
        if (symmetricAlpha < 0.0) {
            throw new IllegalArgumentException("Symmetric alpha should be >= 0: " + symmetricAlpha);
        }
        this.symmetricAlpha = symmetricAlpha;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        switch (this.initializationMode) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Initialiation mode invalid: " + this.initializationMode);
            }
        }
        if (this.symmetricAlpha <= 0.0) {
            throw new IllegalArgumentException("Symmetric alpha invalid: " + this.symmetricAlpha);
        }
    }
}

