/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;

public class EdgeWeightComparison
implements SessionModel {
    static final long serialVersionUID = 23L;
    private String name;
    private SemIm reference;
    private SemIm target;

    public EdgeWeightComparison(SemEstimatorWrapper reference, SemEstimatorWrapper target) {
        this.reference = reference.getEstimatedSemIm();
        this.target = target.getEstimatedSemIm();
    }

    public EdgeWeightComparison(SemImWrapper reference, SemEstimatorWrapper target) {
        this.reference = reference.getSemIm();
        this.target = target.getEstimatedSemIm();
    }

    public EdgeWeightComparison(SemImWrapper reference, SemImWrapper target) {
        this.reference = reference.getSemIm();
        this.target = target.getSemIm();
    }

    public String getDisplayString() {
        String displayString = "";
        SemIm ref = this.reference;
        DoubleMatrix2D referenceMatrix = ref.getEdgeCoef();
        DoubleMatrix2D targetMatrix = this.target.getEdgeCoef();
        if (targetMatrix.columns() != referenceMatrix.columns() || targetMatrix.rows() != referenceMatrix.rows()) {
            return "The SEM IM's you selected don't have the same number of variables!  No comparison is possible here.";
        }
        double score = 0.0;
        for (int i = 0; i < ref.getEdgeCoef().rows(); ++i) {
            for (int j = 0; j < ref.getEdgeCoef().columns(); ++j) {
                score += (targetMatrix.get(i, j) - referenceMatrix.get(i, j)) * (targetMatrix.get(i, j) - referenceMatrix.get(i, j));
            }
        }
        displayString = displayString + "Scheines Score: " + score + "\n\n";
        displayString = displayString + "(Calculated by summing the squared differences\n of each corresponding edge weight.)";
        return displayString;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static EdgeWeightComparison serializableInstance() {
        return new EdgeWeightComparison(SemImWrapper.serializableInstance(), SemImWrapper.serializableInstance());
    }
}

