/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.EmBayesEstimator;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.EmBayesEstimatorParams;
import edu.cmu.tetradapp.model.GraphSource;
import java.io.IOException;
import java.io.ObjectInputStream;

public class EmBayesEstimatorWrapper
implements SessionModel,
GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private BayesPm bayesPm;
    private DataSet dataSet;
    private BayesIm estimateBayesIm;

    public EmBayesEstimatorWrapper(DataWrapper dataWrapper, BayesPmWrapper bayesPmWrapper, EmBayesEstimatorParams params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (bayesPmWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        BayesPm bayesPm = bayesPmWrapper.getBayesPm();
        EmBayesEstimator estimator = new EmBayesEstimator(bayesPm, dataSet);
        this.dataSet = estimator.getMixedDataSet();
        try {
            estimator.maximization(params.getTolerance());
            this.estimateBayesIm = estimator.getEstimatedIm();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Please specify the search tolerance first.");
        }
        TetradLogger.getInstance().log("info", "EM-Estimated Bayes IM:");
        TetradLogger.getInstance().log("im", "" + this.estimateBayesIm);
    }

    public EmBayesEstimatorWrapper(DataWrapper dataWrapper, BayesImWrapper bayesImWrapper, EmBayesEstimatorParams params) {
        TetradLogger.getInstance().log("info", "EM-Estimated Bayes IM:");
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (bayesImWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        BayesPm bayesPm = bayesImWrapper.getBayesIm().getBayesPm();
        EmBayesEstimator estimator = new EmBayesEstimator(bayesPm, dataSet);
        this.dataSet = estimator.getMixedDataSet();
        try {
            estimator.maximization(params.getTolerance());
            this.estimateBayesIm = estimator.getEstimatedIm();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Please specify the search tolerance first.");
        }
        TetradLogger.getInstance().log("im", "" + this.estimateBayesIm);
    }

    public static EmBayesEstimatorWrapper serializableInstance() {
        return new EmBayesEstimatorWrapper(DataWrapper.serializableInstance(), BayesPmWrapper.serializableInstance(), new EmBayesEstimatorParams());
    }

    public BayesIm getEstimateBayesIm() {
        return this.estimateBayesIm;
    }

    private void estimate(DataSet dataSet, BayesPm bayesPm, double thresh) {
        try {
            EmBayesEstimator estimator = new EmBayesEstimator(bayesPm, dataSet);
            this.estimateBayesIm = estimator.maximization(thresh);
            this.dataSet = estimator.getMixedDataSet();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new RuntimeException("Value assignments between Bayes PM and discrete data set do not match.");
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dataSet == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.estimateBayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

