/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GeneralizedSemImWrapper;
import edu.cmu.tetradapp.model.SemDataParams;

public class GeneralizedSemDataWrapper
extends DataWrapper
implements SessionModel {
    static final long serialVersionUID = 23L;
    private GeneralizedSemIm semIm = null;

    public GeneralizedSemDataWrapper(GeneralizedSemImWrapper wrapper, SemDataParams params) {
        int sampleSize = params.getSampleSize();
        boolean latentDataSaved = params.isIncludeLatents();
        GeneralizedSemIm semIm = wrapper.getSemIm();
        semIm.setSimulatePositiveDataOnly(params.isPositiveDataOnly());
        DataSet columnDataModel = semIm.simulateData(sampleSize, latentDataSaved);
        this.setDataModel(columnDataModel);
        this.setSourceGraph(semIm.getSemPm().getGraph());
        this.setParams(params);
        this.semIm = semIm;
        LogObjectsUtils.logDataModelList("Data simulated from a generalized SEM model.", this.getDataModelList());
    }

    public GeneralizedSemIm getSemIm() {
        return this.semIm;
    }

    public static DataWrapper serializableInstance() {
        return new GeneralizedSemDataWrapper(GeneralizedSemImWrapper.serializableInstance(), SemDataParams.serializableInstance());
    }
}

