/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Ges;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.MbUtils;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.ScoredGraph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetradapp.editor.Indexable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GesIndTestParams;
import edu.cmu.tetradapp.model.GesParams;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.IGesRunner;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.MeekSearchParams;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GesRunner
extends AbstractAlgorithmRunner
implements GraphSource,
PropertyChangeListener,
Indexable,
IGesRunner {
    static final long serialVersionUID = 23L;
    private transient List<PropertyChangeListener> listeners;
    private Map<Graph, Double> dagsToScores;
    private List<ScoredGraph> topGraphs;
    private int index;
    private List<Map<Graph, Double>> allDagsToScores;

    public GesRunner(DataWrapper dataWrapper, GesParams params) {
        super(dataWrapper, (SearchParams)params, null);
    }

    public GesRunner(DataWrapper dataWrapper, GesParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public GesRunner(GraphSource graphWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public static IGesRunner serializableInstance() {
        return new GesRunner(DataWrapper.serializableInstance(), GesParams.serializableInstance());
    }

    @Override
    public void execute() {
        Ges ges;
        DataModel source = this.getDataModel();
        GesParams gesParams = (GesParams)this.getParams();
        GesIndTestParams indTestParams = (GesIndTestParams)gesParams.getIndTestParams();
        double penalty = gesParams.getComplexityPenalty();
        if (source instanceof CovarianceMatrix) {
            ges = new Ges((CovarianceMatrix)source);
            ges.addPropertyChangeListener(this);
            ges.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
            ges.setKnowledge(this.getParams().getKnowledge());
            ges.setSamplePrior(((GesParams)this.getParams()).getCellPrior());
            ges.setStructurePrior(((GesParams)this.getParams()).getStructurePrior());
            ges.setPenaltyDiscount(penalty);
            ges.setNumPatternsToStore(indTestParams.getNumPatternsToSave());
        } else if (source instanceof DataSet) {
            ges = new Ges((DataSet)source);
            ges.addPropertyChangeListener(this);
            ges.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
            ges.setKnowledge(this.getParams().getKnowledge());
            ges.setSamplePrior(((GesParams)this.getParams()).getCellPrior());
            ges.setStructurePrior(((GesParams)this.getParams()).getStructurePrior());
            ges.setPenaltyDiscount(penalty);
            ges.setNumPatternsToStore(indTestParams.getNumPatternsToSave());
        } else {
            throw new RuntimeException("GES does not accept this type of data set.");
        }
        Graph graph = ges.search();
        this.setResultGraph(graph);
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (this.getParams().getKnowledge().isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, this.getParams().getKnowledge());
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
        this.topGraphs = new ArrayList<ScoredGraph>(ges.getTopGraphs());
        this.allDagsToScores = new ArrayList<Map<Graph, Double>>();
        for (ScoredGraph scoredGraph : this.topGraphs) {
            Map<Graph, Double> dagsToScores = this.scoreGraphs(ges, scoredGraph.getGraph());
            this.allDagsToScores.add(dagsToScores);
        }
        this.setIndex(this.topGraphs.size() - 1);
    }

    @Override
    public void setIndex(int index) {
        if (index < 0 || index > this.topGraphs.size()) {
            throw new IllegalArgumentException("Must be in [0, " + (this.topGraphs.size() - 1) + ".");
        }
        this.dagsToScores = this.allDagsToScores.get(index);
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    private Map<Graph, Double> scoreGraphs(Ges ges, Graph graph) {
        List<Graph> dags = MbUtils.generatePatternDags(graph, false);
        HashMap<Graph, Double> dagsToScores = new HashMap<Graph, Double>();
        for (Graph _graph : dags) {
            double score = ges.scoreGraph(_graph);
            dagsToScores.put(_graph, score);
        }
        return dagsToScores;
    }

    @Override
    public Graph getGraph() {
        return this.getTopGraphs().get(this.getIndex()).getGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        return triplesList;
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setKnowledge(this.getParams().getKnowledge());
        return rules;
    }

    private boolean isAggressivelyPreventCycles() {
        SearchParams params = this.getParams();
        if (params instanceof MeekSearchParams) {
            return ((MeekSearchParams)params).isAggressivelyPreventCycles();
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }

    private void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.getListeners()) {
            l.propertyChange(evt);
        }
    }

    private List<PropertyChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        return this.listeners;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.getListeners().contains(l)) {
            this.getListeners().add(l);
        }
    }

    @Override
    public Map<Graph, Double> getDagsToScores() {
        return this.dagsToScores;
    }

    @Override
    public List<ScoredGraph> getTopGraphs() {
        return this.topGraphs;
    }
}

