/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetrad.session.ExecutionRestarter;
import edu.cmu.tetrad.session.SessionAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.LinkedList;

public class GraphComparisonParams
extends SessionAdapter
implements Params,
ExecutionRestarter {
    static final long serialVersionUID = 23L;
    private DataSet dataSet;
    private boolean resetTableOnExecute = true;
    private boolean keepLatents = false;
    private String referenceGraphName;
    private String targetGraphName;
    private DiscreteVariable missingEdgesVar;
    private DiscreteVariable correctEdgesVar;
    private DiscreteVariable extraEdgesVar;

    public GraphComparisonParams() {
        this.newExecution();
    }

    public static GraphComparisonParams serializableInstance() {
        return new GraphComparisonParams();
    }

    public void addRecord(int adjCorrect, int adjFn, int adjFp, int arrowptCorrect, int arrowptFn, int arrowptFp) {
        int newRow = this.dataSet.getNumRows();
        this.dataSet.setInt(newRow, 0, adjCorrect);
        this.dataSet.setInt(newRow, 1, adjFn);
        this.dataSet.setInt(newRow, 2, adjFp);
        this.dataSet.setInt(newRow, 3, arrowptCorrect);
        this.dataSet.setInt(newRow, 4, arrowptFn);
        this.dataSet.setInt(newRow, 5, arrowptFp);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public final void newExecution() {
        if (this.isResetTableOnExecute()) {
            DiscreteVariable adjCorrect = new DiscreteVariable("ADJ_COR");
            DiscreteVariable adjFn = new DiscreteVariable("ADJ_FN");
            DiscreteVariable adjFp = new DiscreteVariable("ADJ_FP");
            DiscreteVariable arrowptCorrect = new DiscreteVariable("APT_COR");
            DiscreteVariable arrowptFn = new DiscreteVariable("APT_FN");
            DiscreteVariable arrowptFp = new DiscreteVariable("APT_FP");
            LinkedList<Node> variables = new LinkedList<Node>();
            variables.add(adjCorrect);
            variables.add(adjFn);
            variables.add(adjFp);
            variables.add(arrowptCorrect);
            variables.add(arrowptFn);
            variables.add(arrowptFp);
            this.dataSet = new ColtDataSet(0, variables);
            Hashtable<String, String> columnToTooltip = new Hashtable<String, String>();
            columnToTooltip.put("ADJ_COR", "Adjacencies in the reference graph that are in the true graph.");
            columnToTooltip.put("ADJ_FN", "Adjacencies in the true graph that are not in the reference graph.");
            columnToTooltip.put("ADJ_FP", "Adjacencies in the reference graph that are not in the true graph.");
            columnToTooltip.put("APT_COR", "Arrowpoints in the reference graph that are in the true graph.");
            columnToTooltip.put("APT_FN", "Arrowpoints in the true graph that are not in the reference graph.");
            columnToTooltip.put("APT_FP", "Arrowpoints in the reference graph that are not in the true graph.");
            System.out.println("columnToTooltip " + columnToTooltip);
            this.dataSet.setColumnToTooltip(columnToTooltip);
        }
    }

    public boolean isResetTableOnExecute() {
        return this.resetTableOnExecute;
    }

    public void setResetTableOnExecute(boolean resetTableOnExecute) {
        this.resetTableOnExecute = resetTableOnExecute;
    }

    public boolean isKeepLatents() {
        return this.keepLatents;
    }

    public void setKeepLatents(boolean keepLatents) {
        this.keepLatents = keepLatents;
    }

    public void setReferenceGraphName(String name) {
        this.referenceGraphName = name;
    }

    public String getReferenceGraphName() {
        return this.referenceGraphName;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public void setTargetGraphName(String targetGraphName) {
        this.targetGraphName = targetGraphName;
    }

    public String getTargetGraphName() {
        return this.targetGraphName;
    }
}

