/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphParams;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.MimBuildRunner;
import edu.cmu.tetradapp.model.PurifyRunner;
import edu.cmu.tetradapp.model.ScoredGraphsWrapper;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.prefs.Preferences;

public class GraphWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private Graph graph;

    public GraphWrapper(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.graph = graph;
        this.log();
    }

    public GraphWrapper(Graph graph, String message) {
        TetradLogger.getInstance().log("info", message);
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.graph = graph;
    }

    public GraphWrapper(GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.graph = new EdgeListGraph();
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.makeRandomGraph();
        }
        this.log();
    }

    public GraphWrapper(GraphWrapper graphWrapper, GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.graph = new EdgeListGraph(graphWrapper.getGraph());
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.makeRandomGraph();
        }
        this.log();
    }

    public GraphWrapper(DagWrapper dagWrapper, GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.graph = new EdgeListGraph(dagWrapper.getDag());
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.makeRandomGraph();
        }
        this.log();
    }

    public GraphWrapper(SemGraphWrapper graphWrapper, GraphParams params) {
        if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 0) {
            this.graph = new EdgeListGraph(graphWrapper.getGraph());
        } else if (Preferences.userRoot().getInt("newGraphInitializationMode", 0) == 1) {
            this.makeRandomGraph();
        }
        this.log();
    }

    public GraphWrapper(AlgorithmRunner wrapper) {
        this(new EdgeListGraph(wrapper.getResultGraph()));
    }

    public GraphWrapper(DataWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getVariables()));
        GraphUtils.arrangeInCircle(this.graph, 200, 200, 150);
    }

    public GraphWrapper(BayesPmWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getBayesPm().getDag()));
    }

    public GraphWrapper(BayesImWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getBayesIm().getBayesPm().getDag()));
    }

    public GraphWrapper(BayesEstimatorWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getEstimatedBayesIm().getBayesPm().getDag()));
    }

    public GraphWrapper(CptInvariantUpdaterWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getBayesUpdater().getManipulatedGraph()));
    }

    public GraphWrapper(SemPmWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getSemPm().getGraph()));
    }

    public GraphWrapper(SemImWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getSemIm().getSemPm().getGraph()));
    }

    public GraphWrapper(SemEstimatorWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getSemEstimator().getEstimatedSem().getSemPm().getGraph()));
    }

    public GraphWrapper(PurifyRunner wrapper) {
        this(wrapper.getResultGraph());
    }

    public GraphWrapper(BuildPureClustersRunner wrapper) {
        this(wrapper.getResultGraph());
    }

    public GraphWrapper(MimBuildRunner wrapper) {
        this(wrapper.getResultGraph());
    }

    public GraphWrapper(ScoredGraphsWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public static GraphWrapper serializableInstance() {
        return new GraphWrapper(Dag.serializableInstance());
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
        this.log();
    }

    private void log() {
        TetradLogger.getInstance().log("info", "General Graph");
        TetradLogger.getInstance().log("graph", "" + this.getGraph());
    }

    private void makeRandomGraph() {
        this.graph = null;
        while (this.graph == null) {
            Dag dag;
            boolean uniformlySelected = Preferences.userRoot().getBoolean("graphUniformlySelected", true);
            int numMeasuredNodes = Preferences.userRoot().getInt("newGraphNumMeasuredNodes", 5);
            int numLatents = Preferences.userRoot().getInt("newGraphNumLatents", 0);
            int newGraphNumEdges = Preferences.userRoot().getInt("newGraphNumEdges", 3);
            boolean connected = Preferences.userRoot().getBoolean("randomGraphConnected", false);
            if (uniformlySelected) {
                int maxDegree = Preferences.userRoot().getInt("randomGraphMaxDegree", 6);
                int maxIndegree = Preferences.userRoot().getInt("randomGraphMaxIndegree", 3);
                int maxOutdegree = Preferences.userRoot().getInt("randomGraphMaxOutdegree", 3);
                dag = GraphUtils.randomDag(numMeasuredNodes + numLatents, numLatents, newGraphNumEdges, maxDegree, maxIndegree, maxOutdegree, connected);
            } else {
                while ((dag = GraphUtils.randomDag(numMeasuredNodes + numLatents, numLatents, newGraphNumEdges, 30, 15, 15, connected)).getNumEdges() < newGraphNumEdges) {
                }
            }
            boolean addCycles = Preferences.userRoot().getBoolean("randomGraphAddCycles", false);
            if (addCycles) {
                int minNumCycles = Preferences.userRoot().getInt("randomGraphMinNumCycles", 0);
                int minCycleLength = Preferences.userRoot().getInt("randomGraphMinCycleLength", 2);
                this.graph = GraphUtils.addCycles2(dag, minNumCycles, minCycleLength);
                continue;
            }
            this.graph = new EdgeListGraph(dag);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.graph == null) {
            this.graph = new EdgeListGraph();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.graph;
    }

    @Override
    public List<String> getVariableNames() {
        return this.graph.getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.graph.getNodes();
    }
}

