/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.CaseExpander;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.IndTestChiSquare;
import edu.cmu.tetrad.search.IndTestCramerT;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestFisherZBootstrap;
import edu.cmu.tetrad.search.IndTestFisherZGeneralizedInverse;
import edu.cmu.tetrad.search.IndTestFisherZOnTheFly;
import edu.cmu.tetrad.search.IndTestGSquare;
import edu.cmu.tetrad.search.IndTestRegression;
import edu.cmu.tetrad.search.IndTestTimeSeries;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetradapp.model.BasicIndTestParams;
import edu.cmu.tetradapp.model.GraphIndTestParams;
import edu.cmu.tetradapp.model.IndTestParams;
import edu.cmu.tetradapp.model.LagIndTestParams;
import edu.cmu.tetradapp.model.SearchParams;

public final class IndTestFactory {
    public IndependenceTest getTest(Object dataSource, SearchParams params) {
        return this.getTest(dataSource, params, IndTestType.DEFAULT);
    }

    public IndependenceTest getTest(Object dataSource, SearchParams params, IndTestType testType) {
        if (dataSource == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        IndTestParams indTestParams = params.getIndTestParams();
        if (indTestParams == null) {
            indTestParams = new BasicIndTestParams();
            params.setIndTestParams2(indTestParams);
        }
        if (dataSource instanceof DataSet) {
            DataSet dataSet = (DataSet)dataSource;
            if (dataSet.isContinuous() || dataSet.getNumColumns() == 0) {
                DataSet dataContinuous = (DataSet)dataSource;
                if (dataContinuous.isMulipliersCollapsed()) {
                    dataContinuous = new CaseExpander().filter(dataSet);
                }
                return this.getContinuousTest(dataContinuous, params, testType);
            }
            if (dataSet.isDiscrete()) {
                DataSet dataDiscrete = (DataSet)dataSource;
                if (dataDiscrete.isMulipliersCollapsed()) {
                    dataDiscrete = new CaseExpander().filter(dataSet);
                }
                return this.getDiscreteTest(dataDiscrete, params, testType);
            }
        }
        if (dataSource instanceof Graph) {
            return this.getGraphTest((Graph)dataSource, params, IndTestType.D_SEPARATION);
        }
        if (dataSource instanceof CovarianceMatrix) {
            return this.getCovMatrixTest((CovarianceMatrix)dataSource, params, testType);
        }
        if (dataSource instanceof TimeSeriesData) {
            return this.timeSeriesTest((TimeSeriesData)dataSource, params);
        }
        throw new IllegalStateException("Unrecognized data source type: " + dataSource.getClass());
    }

    private IndependenceTest getContinuousTest(DataSet dataSet, SearchParams params, IndTestType testType) {
        IndTestParams indTestParams = params.getIndTestParams();
        if (IndTestType.CORRELATION_T == testType) {
            return new IndTestCramerT(dataSet, indTestParams.getAlpha());
        }
        if (IndTestType.FISHER_Z == testType) {
            return new IndTestFisherZOnTheFly(dataSet, indTestParams.getAlpha());
        }
        if (IndTestType.FISHER_ZD == testType) {
            return new IndTestFisherZGeneralizedInverse(dataSet, indTestParams.getAlpha());
        }
        if (IndTestType.FISHER_Z_BOOTSTRAP == testType) {
            return new IndTestFisherZBootstrap(dataSet, indTestParams.getAlpha(), 15, dataSet.getNumRows() / 2);
        }
        if (IndTestType.LINEAR_REGRESSION == testType) {
            return new IndTestRegression(dataSet, indTestParams.getAlpha());
        }
        params.setIndTestType(IndTestType.FISHER_Z);
        return new IndTestFisherZ(dataSet, indTestParams.getAlpha());
    }

    private IndependenceTest getDiscreteTest(DataSet dataDiscrete, SearchParams params, IndTestType testType) {
        IndTestParams indTestParams = params.getIndTestParams();
        if (IndTestType.G_SQUARE == testType) {
            return new IndTestGSquare(dataDiscrete, indTestParams.getAlpha());
        }
        if (IndTestType.CHI_SQUARE == testType) {
            return new IndTestChiSquare(dataDiscrete, indTestParams.getAlpha());
        }
        params.setIndTestType(IndTestType.CHI_SQUARE);
        return new IndTestChiSquare(dataDiscrete, indTestParams.getAlpha());
    }

    private IndependenceTest getGraphTest(Graph data, SearchParams params, IndTestType testType) {
        if (IndTestType.D_SEPARATION == testType) {
            return new IndTestDSep(data);
        }
        params.setIndTestType(IndTestType.D_SEPARATION);
        return new IndTestDSep(data);
    }

    private IndependenceTest getCovMatrixTest(CovarianceMatrix covMatrix, SearchParams params, IndTestType testType) {
        if (IndTestType.CORRELATION_T == testType) {
            return new IndTestCramerT(covMatrix, params.getIndTestParams().getAlpha());
        }
        if (IndTestType.FISHER_Z == testType) {
            return new IndTestFisherZ(covMatrix, params.getIndTestParams().getAlpha());
        }
        params.setIndTestType(IndTestType.CORRELATION_T);
        return new IndTestCramerT(covMatrix, params.getIndTestParams().getAlpha());
    }

    private IndependenceTest timeSeriesTest(TimeSeriesData data, SearchParams params) {
        IndTestParams indTestParams = params.getIndTestParams();
        if (!(indTestParams instanceof LagIndTestParams) || this.getOldNumTimePoints(indTestParams) != data.getNumTimePoints()) {
            indTestParams = new LagIndTestParams();
            ((LagIndTestParams)indTestParams).setNumTimePoints(data.getData().rows());
            params.setIndTestParams2(indTestParams);
        }
        IndTestTimeSeries test = new IndTestTimeSeries(data.getData(), data.getVariables());
        test.setAlpha(indTestParams.getAlpha());
        test.setNumLags(((LagIndTestParams)indTestParams).getNumLags());
        return test;
    }

    public void adjustIndTestParams(Object dataSource, SearchParams params) {
        if (dataSource instanceof DataSet) {
            DataSet dataSet = (DataSet)dataSource;
            if (dataSet.isContinuous()) {
                IndTestParams indTestParams = params.getIndTestParams();
                if (indTestParams == null) {
                    indTestParams = new BasicIndTestParams();
                    params.setIndTestParams2(indTestParams);
                }
                return;
            }
            if (dataSet.isDiscrete()) {
                IndTestParams indTestParams = params.getIndTestParams();
                if (indTestParams == null) {
                    indTestParams = new BasicIndTestParams();
                    params.setIndTestParams2(indTestParams);
                }
                return;
            }
            throw new IllegalStateException("Tabular data must be either continuous or discrete.");
        }
        if (dataSource instanceof CorrelationMatrix) {
            IndTestParams indTestParams = params.getIndTestParams();
            if (indTestParams == null) {
                indTestParams = new BasicIndTestParams();
                params.setIndTestParams2(indTestParams);
            }
            return;
        }
        if (dataSource instanceof CovarianceMatrix) {
            IndTestParams indTestParams = params.getIndTestParams();
            if (indTestParams == null) {
                indTestParams = new BasicIndTestParams();
                params.setIndTestParams2(indTestParams);
            }
            return;
        }
        if (dataSource instanceof Graph) {
            IndTestParams indTestParams = params.getIndTestParams();
            if (indTestParams == null) {
                indTestParams = new GraphIndTestParams();
                params.setIndTestParams2(indTestParams);
            }
            return;
        }
        if (dataSource instanceof TimeSeriesData) {
            TimeSeriesData data = (TimeSeriesData)dataSource;
            IndTestParams indTestParams = params.getIndTestParams();
            if (indTestParams == null || !(indTestParams instanceof BasicIndTestParams) || this.getOldNumTimePoints(indTestParams) != data.getNumTimePoints()) {
                indTestParams = new BasicIndTestParams();
                params.setIndTestParams2(indTestParams);
            }
            return;
        }
        throw new IllegalStateException("Unrecognized data type.");
    }

    private int getOldNumTimePoints(IndTestParams indTestParams) {
        return ((LagIndTestParams)indTestParams).getNumTimePoints();
    }
}

