/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.ParamsResettable;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.model.KnowledgeParams;
import java.util.ArrayList;
import java.util.List;

public class KnowledgeBoxModel
implements SessionModel,
ParamsResettable,
KnowledgeEditable {
    static final long serialVersionUID = 23L;
    private String name;
    private KnowledgeParams params;
    private KnowledgeBoxInput knowledgeBoxInput;
    private List<String> varNames = new ArrayList<String>();
    private Knowledge knowledge;
    private List<Knowledge> knowledgeList;

    private KnowledgeBoxModel() {
    }

    public KnowledgeBoxModel(KnowledgeBoxInput variableSource, KnowledgeParams params) {
        if (variableSource == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        this.knowledgeBoxInput = variableSource;
        this.params = params;
        if (this.knowledgeBoxInput == null) {
            this.knowledgeBoxInput = new KnowledgeBoxInput(){
                static final long serialVersionUID = 23L;

                @Override
                public Graph getSourceGraph() {
                    return new EdgeListGraph();
                }

                @Override
                public List<Node> getVariables() {
                    return new ArrayList<Node>();
                }

                @Override
                public List<String> getVariableNames() {
                    return new ArrayList<String>();
                }

                @Override
                public void setName(String name) {
                }

                @Override
                public String getName() {
                    return "";
                }
            };
        }
        if (params.getKnowledge().isEmpty()) {
            this.freshenKnowledgeIfEmpty(params);
        }
        TetradLogger.getInstance().log("info", "Knowledge");
        if (!params.getKnowledge().isEmpty()) {
            TetradLogger.getInstance().log("knowledge", params.getKnowledge().toString());
        }
    }

    private void freshenKnowledgeIfEmpty(KnowledgeParams params) {
        if (params.getKnowledge().isEmpty()) {
            this.createKnowledge(params.getKnowledge());
            for (String varName : this.knowledgeBoxInput.getVariableNames()) {
                if (varName.startsWith("E_")) continue;
                this.varNames.add(varName);
            }
        }
    }

    public static KnowledgeBoxModel serializableInstance() {
        return new KnowledgeBoxModel(GraphWrapper.serializableInstance(), new KnowledgeParams());
    }

    private Knowledge createKnowledge(Knowledge knowledge) {
        knowledge.clear();
        for (String varName : this.varNames) {
            knowledge.addVariable(varName);
        }
        return knowledge;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.params.getKnowledge();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.knowledgeBoxInput.getSourceGraph();
    }

    @Override
    public List<String> getVarNames() {
        return this.varNames;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.params.setKnowledge(knowledge);
        TetradLogger.getInstance().log("knowledge", knowledge.toString());
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void resetParams(Object params) {
        this.params = (KnowledgeParams)params;
        this.freshenKnowledgeIfEmpty(this.params);
        TetradLogger.getInstance().log("knowledge", this.params.getKnowledge().toString());
    }

    @Override
    public Object getResettableParams() {
        return this.params;
    }
}

