/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Ges;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.LingamPattern;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.CpcRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IGesRunner;
import edu.cmu.tetradapp.model.IcpcRunner;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.LingamStructureRunner;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class LingamPatternRunner
extends AbstractAlgorithmRunner
implements GraphSource,
PropertyChangeListener {
    static final long serialVersionUID = 23L;
    private transient List<PropertyChangeListener> listeners;
    private Graph pattern;

    public LingamPatternRunner(GraphWrapper graphWrapper, DataWrapper dataWrapper, PcSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
        this.pattern = graphWrapper.getGraph();
    }

    public LingamPatternRunner(GraphWrapper graphWrapper, DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
        this.pattern = graphWrapper.getGraph();
    }

    public LingamPatternRunner(GraphSource graphWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public LingamPatternRunner(GraphSource graphWrapper, PcSearchParams params) {
        super(graphWrapper.getGraph(), (SearchParams)params, null);
    }

    public LingamPatternRunner(PcRunner wrapper, DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
        this.pattern = wrapper.getGraph();
    }

    public LingamPatternRunner(PcRunner wrapper, DataWrapper dataWrapper, PcSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
        this.pattern = wrapper.getGraph();
    }

    public LingamPatternRunner(CpcRunner wrapper, DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
        this.pattern = wrapper.getGraph();
    }

    public LingamPatternRunner(CpcRunner wrapper, DataWrapper dataWrapper, PcSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
        this.pattern = wrapper.getGraph();
    }

    public LingamPatternRunner(IcpcRunner wrapper, DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
        this.pattern = wrapper.getGraph();
    }

    public LingamPatternRunner(IcpcRunner wrapper, DataWrapper dataWrapper, PcSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
        this.pattern = wrapper.getGraph();
    }

    public LingamPatternRunner(IGesRunner wrapper, DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
        this.pattern = wrapper.getGraph();
    }

    public LingamPatternRunner(IGesRunner wrapper, DataWrapper dataWrapper, PcSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
        this.pattern = wrapper.getGraph();
    }

    public static LingamStructureRunner serializableInstance() {
        return new LingamStructureRunner(DataWrapper.serializableInstance(), PcSearchParams.serializableInstance(), KnowledgeBoxModel.serializableInstance());
    }

    @Override
    public void execute() {
        DataModel source = this.getDataModel();
        if (!(source instanceof DataSet)) {
            throw new IllegalArgumentException("Expecting a rectangular data set.");
        }
        DataSet dataSet = (DataSet)source;
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Expecting a continuous data set.");
        }
        if (this.pattern == null) {
            Ges search = new Ges(dataSet);
            search.setKnowledge(this.getParams().getKnowledge());
            this.pattern = search.search();
        }
        LingamPattern lingamPattern = new LingamPattern(this.pattern, dataSet);
        lingamPattern.setKnowledge(this.getParams().getKnowledge());
        Graph graph = lingamPattern.search();
        this.setResultGraph(graph);
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (this.getParams().getKnowledge().isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, this.getParams().getKnowledge());
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Colliders");
        names.add("Noncolliders");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        triplesList.add(GraphUtils.getCollidersFromGraph(node, graph));
        triplesList.add(GraphUtils.getNoncollidersFromGraph(node, graph));
        return triplesList;
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setKnowledge(this.getParams().getKnowledge());
        return rules;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }

    private void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.getListeners()) {
            l.propertyChange(evt);
        }
    }

    private List<PropertyChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.getListeners().contains(l)) {
            this.getListeners().add(l);
        }
    }

    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        IndTestType testType = this.getParams().getIndTestType();
        return new IndTestFactory().getTest(dataModel, this.getParams(), testType);
    }
}

