/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.Lingam_old;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.LingamParams;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;

public class LingamRunner
extends AbstractAlgorithmRunner
implements GraphSource,
PropertyChangeListener {
    static final long serialVersionUID = 23L;
    private transient List<PropertyChangeListener> listeners;

    public LingamRunner(DataWrapper dataWrapper) {
        super(dataWrapper, (SearchParams)new LingamParams(), null);
    }

    public LingamRunner(DataWrapper dataWrapper, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)new LingamParams(), knowledgeBoxModel);
    }

    public LingamRunner(GraphSource graphWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public LingamRunner(GraphSource graphWrapper, PcSearchParams params) {
        super(graphWrapper.getGraph(), (SearchParams)params, null);
    }

    public static LingamRunner serializableInstance() {
        return new LingamRunner(DataWrapper.serializableInstance(), KnowledgeBoxModel.serializableInstance());
    }

    @Override
    public void execute() {
        DataModel source = this.getDataModel();
        if (!(source instanceof DataSet)) {
            throw new IllegalArgumentException("Expecting a rectangular data set.");
        }
        DataSet data = (DataSet)source;
        if (!data.isContinuous()) {
            throw new IllegalArgumentException("Expecting a continuous data set.");
        }
        Lingam_old lingam = new Lingam_old();
        lingam.setAlpha(this.getParams().getIndTestParams().getAlpha());
        lingam.setPruningDone(true);
        double lingamPruningAlpha = Preferences.userRoot().getDouble("lingamPruningAlpha", 0.05);
        lingam.setAlpha(lingamPruningAlpha);
        Graph graph = lingam.lingam(data).getGraph();
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
        GraphUtils.arrangeBySourceGraph(this.getResultGraph(), this.getSourceGraph());
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Colliders");
        names.add("Noncolliders");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        triplesList.add(GraphUtils.getCollidersFromGraph(node, graph));
        triplesList.add(GraphUtils.getNoncollidersFromGraph(node, graph));
        return triplesList;
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setKnowledge(this.getParams().getKnowledge());
        return rules;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }

    private void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.getListeners()) {
            l.propertyChange(evt);
        }
    }

    private List<PropertyChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.getListeners().contains(l)) {
            this.getListeners().add(l);
        }
    }
}

