/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.regression.LogisticRegression;
import edu.cmu.tetrad.regression.LogisticRegressionResult;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.LogisticRegressionParams;
import edu.cmu.tetradapp.model.SearchParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class LogisticRegressionRunner
implements AlgorithmRunner {
    static final long serialVersionUID = 23L;
    private String name;
    private LogisticRegressionParams params;
    private String targetName;
    private DataSet dataSet;
    private String report;
    private Graph outGraph;
    private LogisticRegressionResult result;
    private double[] coefficients;

    public LogisticRegressionRunner(DataWrapper dataWrapper, LogisticRegressionParams params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataModel dataModel = dataWrapper.getSelectedDataModel();
        if (!(dataModel instanceof DataSet)) {
            throw new IllegalArgumentException("Data set must be tabular.");
        }
        DataSet dataSet = (DataSet)dataModel;
        this.params = params;
        this.targetName = params.getTargetName();
        this.dataSet = dataSet;
        TetradLogger.getInstance().log("info", "Linear Regression");
        if (this.result == null) {
            TetradLogger.getInstance().log("info", "Please double click this regression node to run the regession.");
        } else {
            TetradLogger.getInstance().log("result", this.report);
        }
    }

    public static LogisticRegressionRunner serializableInstance() {
        LinkedList<Node> variables = new LinkedList<Node>();
        ContinuousVariable var1 = new ContinuousVariable("X");
        ContinuousVariable var2 = new ContinuousVariable("Y");
        variables.add(var1);
        variables.add(var2);
        ColtDataSet dataSet = new ColtDataSet(3, variables);
        double[] col1data = new double[]{0.0, 1.0, 2.0};
        double[] col2data = new double[]{2.3, 4.3, 2.5};
        for (int i = 0; i < 3; ++i) {
            dataSet.setDouble(i, 0, col1data[i]);
            dataSet.setDouble(i, 1, col2data[i]);
        }
        DataWrapper dataWrapper = new DataWrapper(dataSet);
        return new LogisticRegressionRunner(dataWrapper, LogisticRegressionParams.serializableInstance());
    }

    @Override
    public DataModel getDataModel() {
        return this.dataSet;
    }

    public void resetParams(Object params) {
    }

    public void setParams(LogisticRegressionParams params) {
        this.params = params;
    }

    public double getAlpha() {
        if (this.params != null) {
            return this.params.getAlpha();
        }
        return -1.0;
    }

    public boolean isSearchingOverSubset() {
        return false;
    }

    public LogisticRegressionResult getResult() {
        return this.result;
    }

    @Override
    public SearchParams getParams() {
        return this.params;
    }

    @Override
    public Graph getResultGraph() {
        return this.outGraph;
    }

    public void setResultGraph(Graph graph) {
        this.outGraph = graph;
    }

    @Override
    public Graph getSourceGraph() {
        return null;
    }

    @Override
    public void execute() {
        if (this.params.getRegressorNames().length == 0 || this.params.getTargetName() == null) {
            this.report = "Response and predictor variables not set.";
            this.outGraph = new EdgeListGraph();
            return;
        }
        if (Arrays.asList(this.params.getRegressorNames()).contains(this.params.getTargetName())) {
            this.report = "Response var must not be a predictor.";
            this.outGraph = new EdgeListGraph();
            return;
        }
        String targetName = this.params.getTargetName();
        double alpha = this.params.getAlpha();
        ColtDataSet regressorsDataSet = new ColtDataSet((ColtDataSet)this.dataSet);
        Node variable = regressorsDataSet.getVariable(targetName);
        int targetIndex = this.dataSet.getVariables().indexOf(variable);
        regressorsDataSet.removeColumn(variable);
        Object[] namesObj = regressorsDataSet.getVariableNames().toArray();
        String[] names = new String[namesObj.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)namesObj[i];
        }
        String[] regressorNames = this.params.getRegressorNames();
        List<String> regressorNamesList = Arrays.asList(regressorNames);
        if (regressorNames.length > 0) {
            for (String name1 : names) {
                Node regressorVar = regressorsDataSet.getVariable(name1);
                if (regressorNamesList.contains(regressorVar.getName())) continue;
                regressorsDataSet.removeColumn(regressorVar);
            }
        } else {
            regressorNames = names;
        }
        int ncases = regressorsDataSet.getNumRows();
        int nvars = regressorsDataSet.getNumColumns();
        double[][] regressors = new double[nvars][ncases];
        for (int i = 0; i < nvars; ++i) {
            for (int j = 0; j < ncases; ++j) {
                regressors[i][j] = regressorsDataSet.getDouble(j, i);
            }
        }
        int[] target = new int[ncases];
        for (int j = 0; j < ncases; ++j) {
            target[j] = (int)this.dataSet.getDouble(j, targetIndex);
        }
        LogisticRegression logRegression = new LogisticRegression();
        logRegression.setRegressors(regressors);
        logRegression.setVariableNames(regressorNames);
        logRegression.setAlpha(alpha);
        this.report = logRegression.regress(target, targetName);
        this.result = logRegression.getResult();
        this.coefficients = logRegression.getCoefficients();
        this.outGraph = logRegression.getOutGraph();
    }

    @Override
    public boolean supportsKnowledge() {
        return false;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        throw new UnsupportedOperationException();
    }

    public String getReport() {
        return this.report;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public Graph getOutGraph() {
        return this.outGraph;
    }

    public String getTargetName() {
        return this.targetName;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.params == null) {
            throw new NullPointerException();
        }
        if (this.dataSet == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getGraph() {
        return this.outGraph;
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }
}

