/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Mbfs;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.MbSearchParams;
import edu.cmu.tetradapp.model.MeekSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class MbfsRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;
    private transient Mbfs mbfs;

    public MbfsRunner(DataWrapper dataWrapper, MbSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public MbfsRunner(DataWrapper dataWrapper, MbSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
    }

    public MbfsRunner(Graph graph, MbSearchParams params) {
        super(graph, params);
    }

    public MbfsRunner(GraphWrapper dagWrapper, MbSearchParams params) {
        super(dagWrapper.getGraph(), params);
    }

    public MbfsRunner(GraphWrapper dagWrapper, KnowledgeBoxModel knowledgeBoxModel, MbSearchParams params) {
        super(dagWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public MbfsRunner(DagWrapper dagWrapper, MbSearchParams params) {
        super(dagWrapper.getDag(), params);
    }

    public MbfsRunner(DagWrapper dagWrapper, KnowledgeBoxModel knowledgeBoxModel, MbSearchParams params) {
        super(dagWrapper.getDag(), (SearchParams)params, knowledgeBoxModel);
    }

    public MbfsRunner(SemGraphWrapper dagWrapper, MbSearchParams params) {
        super(dagWrapper.getGraph(), params);
    }

    public MbfsRunner(SemGraphWrapper dagWrapper, KnowledgeBoxModel knowledgeBoxModel, MbSearchParams params) {
        super(dagWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public static MbfsRunner serializableInstance() {
        return new MbfsRunner(DataWrapper.serializableInstance(), MbSearchParams.serializableInstance(), KnowledgeBoxModel.serializableInstance());
    }

    @Override
    public void execute() {
        int pcDepth = ((MbSearchParams)this.getParams()).getDepth();
        Mbfs mbfs = new Mbfs(this.getIndependenceTest(), pcDepth);
        SearchParams params = this.getParams();
        if (params instanceof MeekSearchParams) {
            mbfs.setAggressivelyPreventCycles(((MeekSearchParams)params).isAggressivelyPreventCycles());
        }
        Knowledge knowledge = this.getParams().getKnowledge();
        mbfs.setKnowledge(knowledge);
        String targetName = ((MbSearchParams)this.getParams()).getTargetName();
        Graph searchGraph = mbfs.search(targetName);
        this.setResultGraph(searchGraph);
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(searchGraph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(searchGraph, knowledge);
        } else {
            GraphUtils.arrangeInCircle(searchGraph, 200, 200, 150);
        }
        this.mbfs = mbfs;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        MbSearchParams params = (MbSearchParams)this.getParams();
        IndTestType testType = params.getIndTestType();
        return new IndTestFactory().getTest(dataModel, params, testType);
    }

    public Mbfs getMbFanSearch() {
        if (this.mbfs == null) {
            this.execute();
        }
        return this.mbfs;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Colliders");
        names.add("Noncolliders");
        names.add("Ambiguous Triples");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        triplesList.add(GraphUtils.getCollidersFromGraph(node, graph));
        triplesList.add(GraphUtils.getNoncollidersFromGraph(node, graph));
        triplesList.add(GraphUtils.getAmbiguousTriplesFromGraph(node, graph));
        return triplesList;
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }
}

