/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.PValueImprover2;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GesParams;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PValueImproverWrapper
extends AbstractAlgorithmRunner
implements GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private SemIm semIm;
    private transient List<PropertyChangeListener> listeners;
    private DataWrapper dataWrapper;
    private GesParams params;
    private SemIm estSem;
    private Graph trueDag;

    public PValueImproverWrapper(SemImWrapper semImWrapper, DataWrapper dataWrapper, GesParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
        this.dataWrapper = dataWrapper;
        this.params = params;
        this.semIm = semImWrapper.getSemIm();
    }

    public PValueImproverWrapper(SemEstimatorWrapper semEstimatorWrapper, DataWrapper dataWrapper, GesParams params) {
        super(dataWrapper, (SearchParams)params, null);
        this.dataWrapper = dataWrapper;
        this.params = params;
        this.semIm = semEstimatorWrapper.getEstimatedSemIm();
    }

    public PValueImproverWrapper(DataWrapper dataWrapper, GesParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
        this.dataWrapper = dataWrapper;
        this.params = params;
    }

    public PValueImproverWrapper(SemEstimatorWrapper semEstimatorWrapper, DataWrapper dataWrapper, GraphWrapper dagWrapper, GesParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
        this.dataWrapper = dataWrapper;
        this.params = params;
        this.trueDag = dagWrapper.getGraph();
        this.semIm = semEstimatorWrapper.getEstimatedSemIm();
    }

    public static PValueImproverWrapper serializableInstance() {
        return new PValueImproverWrapper(SemImWrapper.serializableInstance(), DataWrapper.serializableInstance(), GesParams.serializableInstance(), KnowledgeBoxModel.serializableInstance());
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void execute() {
        Graph graph;
        DataModel source = this.dataWrapper.getSelectedDataModel();
        if (!(source instanceof DataSet)) {
            throw new RuntimeException("Sem Score Search requires a rectangular dataset.");
        }
        DataSet dataSet = (DataSet)source;
        Knowledge knowledge = this.params.getKnowledge();
        PValueImprover2 search = null;
        if (this.semIm != null) {
            search = new PValueImprover2(this.semIm, dataSet, knowledge);
            search.setKnowledge(knowledge);
            this.fireGraphChange(this.semIm.getSemPm().getGraph());
            search.setTrueDag(this.trueDag);
            this.estSem = search.search();
            graph = this.estSem.getSemPm().getGraph();
        } else {
            search = new PValueImprover2(dataSet, knowledge);
            search.setKnowledge(knowledge);
            graph = search.search3();
        }
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setKnowledge(this.params.getKnowledge());
        return rules;
    }

    private boolean isAggressivelyPreventCycles() {
        return this.params.isAggressivelyPreventCycles();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.getListeners().contains(l)) {
            this.getListeners().add(l);
        }
    }

    private void fireGraphChange(Graph graph) {
        for (PropertyChangeListener l : this.getListeners()) {
            l.propertyChange(new PropertyChangeEvent(this, "graph", null, graph));
        }
    }

    public SemIm getSemIm() {
        return this.semIm;
    }

    public SemIm getEstSem() {
        return this.estSem;
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }

    private List<PropertyChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        return this.listeners;
    }
}

