/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;

public class PatternFromDagGraphWrapper
extends GraphWrapper {
    static final long serialVersionUID = 23L;

    public PatternFromDagGraphWrapper(GraphSource source) {
        this(source.getGraph());
    }

    public PatternFromDagGraphWrapper(Graph graph) {
        super(new EdgeListGraph());
        try {
            new Dag(graph);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The source graph is not a DAG.");
        }
        Graph pattern = PatternFromDagGraphWrapper.getPattern(new Dag(graph));
        this.setGraph(pattern);
        TetradLogger.getInstance().log("info", "\nGenerating pattern from DAG.");
        TetradLogger.getInstance().log("pattern", pattern + "");
    }

    public static PatternFromDagGraphWrapper serializableInstance() {
        return new PatternFromDagGraphWrapper(EdgeListGraph.serializableInstance());
    }

    private static Graph getPattern(Dag dag) {
        return SearchGraphUtils.patternFromDag(dag);
    }
}

