/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestFactory;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.MeekSearchParams;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.util.ArrayList;
import java.util.List;

public class PcRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
GraphSource {
    static final long serialVersionUID = 23L;

    public PcRunner(DataWrapper dataWrapper, PcSearchParams params) {
        super(dataWrapper, (SearchParams)params, null);
    }

    public PcRunner(DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public PcRunner(Graph graph, PcSearchParams params) {
        super(graph, params);
    }

    public PcRunner(GraphWrapper graphWrapper, PcSearchParams params) {
        super(graphWrapper.getGraph(), params);
    }

    public PcRunner(GraphSource graphWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), (SearchParams)params, knowledgeBoxModel);
    }

    public PcRunner(DagWrapper dagWrapper, PcSearchParams params) {
        super(dagWrapper.getDag(), params);
    }

    public PcRunner(SemGraphWrapper dagWrapper, PcSearchParams params) {
        super(dagWrapper.getGraph(), params);
    }

    public static PcRunner serializableInstance() {
        return new PcRunner((Graph)Dag.serializableInstance(), PcSearchParams.serializableInstance());
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
        rules.setKnowledge(this.getParams().getKnowledge());
        return rules;
    }

    @Override
    public void execute() {
        Knowledge knowledge = this.getParams().getKnowledge();
        int depth = this.getParams().getIndTestParams().getDepth();
        Pc pc = new Pc(this.getIndependenceTest());
        pc.setKnowledge(knowledge);
        pc.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
        pc.setDepth(depth);
        Graph graph = pc.search();
        System.out.println(graph);
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        IndTestType testType = this.getParams().getIndTestType();
        return new IndTestFactory().getTest(dataModel, this.getParams(), testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        return triplesList;
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    private boolean isAggressivelyPreventCycles() {
        SearchParams params = this.getParams();
        if (params instanceof MeekSearchParams) {
            return ((MeekSearchParams)params).isAggressivelyPreventCycles();
        }
        return false;
    }
}

