/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.GraphWithParameters;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.Lingam_old;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.MeekSearchParams;
import edu.cmu.tetradapp.model.PcSearchParams;
import edu.cmu.tetradapp.model.SearchParams;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PdpStructureRunner
extends AbstractAlgorithmRunner
implements GraphSource,
PropertyChangeListener {
    static final long serialVersionUID = 23L;
    private transient List<PropertyChangeListener> listeners;

    public PdpStructureRunner(DataWrapper dataWrapper, PcSearchParams params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, (SearchParams)params, knowledgeBoxModel);
    }

    public static PdpStructureRunner serializableInstance() {
        return new PdpStructureRunner(DataWrapper.serializableInstance(), PcSearchParams.serializableInstance(), KnowledgeBoxModel.serializableInstance());
    }

    @Override
    public void execute() {
        DataModel source = this.getDataModel();
        if (!(source instanceof DataSet)) {
            throw new IllegalArgumentException("Expecting a rectangular data set.");
        }
        DataSet data = (DataSet)source;
        if (!data.isContinuous()) {
            throw new IllegalArgumentException("Expecting a continuous data set.");
        }
        Lingam_old lingam = new Lingam_old();
        lingam.setPruningDone(true);
        lingam.setAlpha(this.getParams().getIndTestParams().getAlpha());
        GraphWithParameters result = lingam.lingam(data);
        Graph graph = result.getGraph();
        this.setResultGraph(graph);
        if (this.getSourceGraph() != null) {
            GraphUtils.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else {
            GraphUtils.arrangeInCircle(graph, 200, 200, 150);
        }
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setKnowledge(this.getParams().getKnowledge());
        return rules;
    }

    private boolean isAggressivelyPreventCycles() {
        SearchParams params = this.getParams();
        if (params instanceof MeekSearchParams) {
            return ((MeekSearchParams)params).isAggressivelyPreventCycles();
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }

    private void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.getListeners()) {
            l.propertyChange(evt);
        }
    }

    private List<PropertyChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.getListeners().contains(l)) {
            this.getListeners().add(l);
        }
    }
}

