/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.gene.graph.ActiveLagGraph;
import edu.cmu.tetrad.gene.history.SimpleRandomizer;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetradapp.model.LagGraphParams;

public class RandomActiveLagGraph
extends ActiveLagGraph
implements SessionModel {
    static final long serialVersionUID = 23L;
    private String name;

    public RandomActiveLagGraph(LagGraphParams params) {
        int indegreeType;
        this.addFactors("Gene", params.getVarsPerInd());
        switch (params.getIndegreeType()) {
            case 0: {
                indegreeType = 0;
                break;
            }
            case 1: {
                indegreeType = 1;
                break;
            }
            case 2: {
                indegreeType = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.setMaxLagAllowable(params.getMlag());
        SimpleRandomizer randomizer = new SimpleRandomizer(params.getIndegree(), indegreeType, params.getMlag(), params.getPercentUnregulated());
        randomizer.initialize(this);
    }

    public static ActiveLagGraph serializableInstance() {
        return new RandomActiveLagGraph(LagGraphParams.serializableInstance());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

