/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.regression.RegressionCovariance;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.RegressionParams;
import edu.cmu.tetradapp.model.SearchParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class RegressionRunner
implements AlgorithmRunner {
    static final long serialVersionUID = 23L;
    private String name;
    private RegressionParams params;
    private String targetName;
    private DataModel dataSet;
    private Graph outGraph;
    private RegressionResult result;
    private String report;

    public RegressionRunner(DataWrapper dataWrapper, RegressionParams params) {
        DataSet _dataSet;
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataModel dataModel = dataWrapper.getSelectedDataModel();
        if (dataModel instanceof DataSet && !(_dataSet = (DataSet)dataModel).isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        this.params = params;
        this.targetName = params.getTargetName();
        this.dataSet = dataModel;
        TetradLogger.getInstance().log("info", "Linear Regression");
        if (this.result == null) {
            TetradLogger.getInstance().log("info", "Please double click this regression node to run the regession.");
        } else {
            TetradLogger.getInstance().log("result", this.result.getResultsTable().toString());
        }
    }

    public static RegressionRunner serializableInstance() {
        LinkedList<Node> variables = new LinkedList<Node>();
        ContinuousVariable var1 = new ContinuousVariable("X");
        ContinuousVariable var2 = new ContinuousVariable("Y");
        variables.add(var1);
        variables.add(var2);
        ColtDataSet _dataSet = new ColtDataSet(3, variables);
        double[] col1data = new double[]{0.0, 1.0, 2.0};
        double[] col2data = new double[]{2.3, 4.3, 2.5};
        for (int i = 0; i < 3; ++i) {
            _dataSet.setDouble(i, 0, col1data[i]);
            _dataSet.setDouble(i, 1, col2data[i]);
        }
        DataWrapper dataWrapper = new DataWrapper(_dataSet);
        return new RegressionRunner(dataWrapper, RegressionParams.serializableInstance());
    }

    @Override
    public DataModel getDataModel() {
        return this.dataSet;
    }

    public void resetParams(Object params) {
    }

    public void setParams(RegressionParams params) {
        this.params = params;
    }

    public boolean isSearchingOverSubset() {
        return false;
    }

    @Override
    public SearchParams getParams() {
        return this.params;
    }

    @Override
    public Graph getResultGraph() {
        return this.outGraph;
    }

    public void setResultGraph(Graph graph) {
        this.outGraph = graph;
    }

    @Override
    public Graph getSourceGraph() {
        return null;
    }

    @Override
    public void execute() {
        if (this.params.getRegressorNames().length == 0 || this.params.getTargetName() == null) {
            this.outGraph = new EdgeListGraph();
            return;
        }
        if (Arrays.asList(this.params.getRegressorNames()).contains(this.params.getTargetName())) {
            this.outGraph = new EdgeListGraph();
            return;
        }
        if (this.dataSet instanceof DataSet) {
            DataSet _dataSet = (DataSet)this.dataSet;
            RegressionDataset regression = new RegressionDataset(_dataSet);
            Node target = _dataSet.getVariable(this.params.getTargetName());
            String[] regressorNames = this.params.getRegressorNames();
            LinkedList<Node> regressors = new LinkedList<Node>();
            for (String regressorName : regressorNames) {
                regressors.add(_dataSet.getVariable(regressorName));
            }
            double alpha = this.params.getAlpha();
            regression.setAlpha(alpha);
            this.result = regression.regress(target, regressors);
            this.outGraph = regression.getGraph();
        } else if (this.dataSet instanceof CovarianceMatrix) {
            CovarianceMatrix covariances = (CovarianceMatrix)this.dataSet;
            RegressionCovariance regression = new RegressionCovariance(covariances);
            Node target = covariances.getVariable(this.params.getTargetName());
            String[] regressorNames = this.params.getRegressorNames();
            LinkedList<Node> regressors = new LinkedList<Node>();
            for (String regressorName : regressorNames) {
                regressors.add(covariances.getVariable(regressorName));
            }
            double alpha = this.params.getAlpha();
            regression.setAlpha(alpha);
            this.result = regression.regress(target, regressors);
            this.outGraph = regression.getGraph();
        }
        this.setResultGraph(this.outGraph);
    }

    @Override
    public boolean supportsKnowledge() {
        return false;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        throw new UnsupportedOperationException();
    }

    public RegressionResult getResult() {
        return this.result;
    }

    public Graph getOutGraph() {
        return this.outGraph;
    }

    public String getTargetName() {
        return this.targetName;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.params == null) {
            throw new NullPointerException();
        }
        if (this.dataSet == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getGraph() {
        return this.outGraph;
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }
}

