/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.CorrMatrixConverter;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import java.util.ArrayList;
import java.util.List;

public class RestrictToGraphNodes
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public RestrictToGraphNodes(DataWrapper dataWrapper, GraphSource graphSource) {
        DataModel dataModel = this.restrictToGraphNodes(dataWrapper.getSelectedDataModel(), graphSource.getGraph());
        this.setDataModel(dataModel);
        this.setSourceGraph(graphSource.getGraph());
        LogObjectsUtils.logDataModelList("Restruct parent data to nodes in the paraent graph only.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        DataWrapper wrapper = new DataWrapper(DataUtils.continuousSerializableInstance());
        return new CorrMatrixConverter(wrapper);
    }

    public DataModel restrictToGraphNodes(DataModel dataModel, Graph graph) {
        if (dataModel instanceof DataSet) {
            DataSet data = (DataSet)dataModel;
            ArrayList<Node> dataNodes = new ArrayList<Node>();
            List<Node> graphNodes = graph.getNodes();
            for (Node graphNode : graphNodes) {
                Node variable = data.getVariable(graphNode.getName());
                if (variable == null) continue;
                dataNodes.add(variable);
            }
            DataSet dataSubset = data.subsetColumns(dataNodes);
            return dataSubset;
        }
        if (dataModel instanceof CovarianceMatrix) {
            CovarianceMatrix cov = (CovarianceMatrix)dataModel;
            ArrayList<String> dataNames = new ArrayList<String>();
            List<Node> graphNodes = graph.getNodes();
            for (Node graphNode : graphNodes) {
                Node variable = cov.getVariable(graphNode.getName());
                if (variable == null) continue;
                dataNames.add(variable.getName());
            }
            String[] _dataNames = dataNames.toArray(new String[dataNames.size()]);
            CovarianceMatrix dataSubset = cov.getSubmatrix(_dataNames);
            LogObjectsUtils.logDataModelList("Parent data restricted to variable in the given graph.", this.getDataModelList());
            return dataSubset;
        }
        throw new IllegalStateException("Unexpected data type.");
    }
}

