/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.sem.SemIm2;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.Sem2PmWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Sem2ImWrapper
implements SessionModel,
GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private final SemIm2 semIm2;

    public Sem2ImWrapper(Sem2PmWrapper sem2PmWrapper) {
        if (sem2PmWrapper == null) {
            throw new NullPointerException("SemPmWrapper must not be null.");
        }
        this.semIm2 = new SemIm2(sem2PmWrapper.getSemPm2());
        this.log(this.semIm2);
    }

    public static Sem2ImWrapper serializableInstance() {
        return new Sem2ImWrapper(Sem2PmWrapper.serializableInstance());
    }

    public SemIm2 getSemIm2() {
        return this.semIm2;
    }

    @Override
    public Graph getGraph() {
        return this.semIm2.getSemPm2().getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(SemIm2 im) {
        TetradLogger.getInstance().log("info", "IM type = SEM");
        TetradLogger.getInstance().log("im", im.toString());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semIm2 == null) {
            throw new NullPointerException();
        }
    }
}

