/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.SemDataParams;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemUpdaterWrapper;
import edu.cmu.tetradapp.model.StandardizedSemImWrapper;

public class SemDataWrapper
extends DataWrapper
implements SessionModel {
    static final long serialVersionUID = 23L;
    private SemIm semIm = null;

    public SemDataWrapper(SemImWrapper wrapper, SemDataParams params) {
        int sampleSize = params.getSampleSize();
        boolean latentDataSaved = params.isIncludeLatents();
        SemIm semIm = wrapper.getSemIm();
        semIm.setSimulatedPositiveDataOnly(params.isPositiveDataOnly());
        DataSet columnDataModel = semIm.simulateData(sampleSize, latentDataSaved);
        this.setDataModel(columnDataModel);
        this.setSourceGraph(semIm.getSemPm().getGraph());
        this.setParams(params);
        this.semIm = semIm;
        LogObjectsUtils.logDataModelList("Data simulated from a linear structural equation model.", this.getDataModelList());
    }

    public SemDataWrapper(SemEstimatorWrapper wrapper, SemDataParams params) {
        int sampleSize = params.getSampleSize();
        boolean latentDataSaved = params.isIncludeLatents();
        DataSet dataModelContinuous = wrapper.getSemEstimator().getEstimatedSem().simulateData(sampleSize, latentDataSaved);
        this.setDataModel(dataModelContinuous);
        this.setSourceGraph(wrapper.getSemEstimator().getEstimatedSem().getSemPm().getGraph());
        this.setParams(params);
        this.semIm = wrapper.getEstimatedSemIm();
        LogObjectsUtils.logDataModelList("Data simulated from a linear structural equation model.", this.getDataModelList());
    }

    public SemDataWrapper(SemUpdaterWrapper wrapper, SemDataParams params) {
        int sampleSize = params.getSampleSize();
        boolean latentDataSaved = params.isIncludeLatents();
        DataSet dataModelContinuous = wrapper.getSemUpdater().getUpdatedSemIm().simulateData(sampleSize, latentDataSaved);
        this.setDataModel(dataModelContinuous);
        this.setSourceGraph(wrapper.getSemUpdater().getUpdatedSemIm().getSemPm().getGraph());
        this.setParams(params);
        this.semIm = wrapper.getSemUpdater().getUpdatedSemIm();
        LogObjectsUtils.logDataModelList("Data simulated from a linear structural equation model.", this.getDataModelList());
    }

    public SemDataWrapper(StandardizedSemImWrapper wrapper, SemDataParams params) {
        int sampleSize = params.getSampleSize();
        boolean latentDataSaved = params.isIncludeLatents();
        DataSet columnDataModel = wrapper.getStandardizedSemIm().simulateData(sampleSize, latentDataSaved);
        this.setDataModel(columnDataModel);
        this.setSourceGraph(wrapper.getStandardizedSemIm().getSemPm().getGraph());
        this.setParams(params);
        LogObjectsUtils.logDataModelList("Data simulated from a linear structural equation model.", this.getDataModelList());
    }

    public SemIm getSemIm() {
        return this.semIm;
    }

    public static DataWrapper serializableInstance() {
        return new SemDataWrapper(SemImWrapper.serializableInstance(), SemDataParams.serializableInstance());
    }
}

